% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_mosaic.R
\name{mosaic_chm}
\alias{mosaic_chm}
\title{Calculate Canopy Height Model and Volume}
\usage{
mosaic_chm(
  dsm,
  dtm = NULL,
  points = NULL,
  interpolation = c("Tps", "Kriging"),
  window_size = c(5, 5),
  ground_quantile = 0,
  mask = NULL,
  mask_soil = TRUE,
  verbose = TRUE
)
}
\arguments{
\item{dsm}{A \code{SpatRaster} object representing the digital surface model. Must
be a single-layer raster.}

\item{dtm}{(optional) A \code{SpatRaster} object representing the digital terrain
model. Must be a single-layer raster. If not provided, it can be
interpolated from points or created using a moving window.}

\item{points}{(optional) An \code{sf} object representing sample points for DTM
interpolation. If provided, \code{dtm} will be interpolated using these points.}

\item{interpolation}{(optional) A character string specifying the
interpolation method to use when \code{points} are provided. Options are
"Kriging" (default) or "Tps" (Thin Plate Spline).}

\item{window_size}{An integer  (meters) specifying the window size (rows and
columns, respectively) for creating a DTM using a moving window. Default is
c(10, 10).}

\item{ground_quantile}{Numeric value between \code{0} and \code{1} indicating the
quantile threshold for ground point selection in the CHM computation. Lower
values (e.g., \code{0}) retain the lowest ground points, while higher values
(e.g., \code{1}) consider higher ground elevations. Default is \code{0}, which uses
the lowest points within each window.}

\item{mask}{(optional) A \code{SpatRaster} object used to mask the CHM and volume
results. Default is NULL.}

\item{mask_soil}{Is \code{mask} representing a soil mask (eg., removing plants)? Default is TRUE.}

\item{verbose}{Return the progress messages. Default is TRUE.}
}
\value{
A \code{SpatRaster} object with three layers: \code{dtm} (digital terrain
model), \code{height} (canopy height model), and \code{volume}.
}
\description{
This function calculates the canopy height model (CHM) and the volume for a
given digital surface model (DSM) raster layer. Optionally, a digital terrain
model (DTM) can be provided or interpolated using a set of points or a moving
window.
}
\details{
The function first checks if the input \code{dsm} is a valid single-layer
\code{SpatRaster} object. If \code{dtm} is not provided, The function generates a
Digital Terrain Model (DTM) from a Digital Surface Model (DSM) by
downsampling and smoothing the input raster data. It iterates over the DSM
matrix in windows of specified size, finds the minimum value within each
window, and assigns these values to a downsampled matrix. After downsampling,
the function applies a mean filter to smooth the matrix, enhancing the visual
and analytical quality of the DTM. Afterwards, DTM is resampled with the
original DSM.

If both \code{dsm} and \code{dtm} are provided, the function ensures they have the same
extent and number of cells, resampling \code{dtm} if necessary. The CHM is then
calculated as the difference between \code{dsm} and \code{dtm}, and the volume is
calculated by multiplying the CHM by the pixel size. The results are
optionally masked using the provided \code{mask}.
}
