% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_objects.R
\name{object_to_color}
\alias{object_to_color}
\title{Apply color to image objects}
\usage{
object_to_color(img, index = "NB", color = "blue", plot = TRUE, ...)
}
\arguments{
\item{img}{An image object.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to binary image. See the available indexes with
\code{\link[=pliman_indexes]{pliman_indexes()}} and \code{\link[=image_index]{image_index()}} for more details.}

\item{color}{The color to apply in the image objects. Defaults to \code{"blue"}.}

\item{plot}{Plots the modified image? Defaults to \code{TRUE}.}

\item{...}{Additional arguments passed on to \code{\link[=image_binary]{image_binary()}}.}
}
\value{
An object of class \code{Image}
}
\description{
The function applies the color informed in the argument \code{color} to segmented
objects in the image. The segmentation is performed using image indexes. Use
\code{\link[=image_index]{image_index()}} to identify the better candidate index to segment objects.
}
\examples{
if (interactive() && requireNamespace("EBImage")) {
library(pliman)
img <- image_pliman("la_leaves.jpg")
img2 <- object_to_color(img, index = "G-R")
image_combine(img, img2)
}

}
