% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_imagem.R
\name{image_index}
\alias{image_index}
\alias{plot.image_index}
\title{Image indexes}
\usage{
image_index(
  img,
  index = NULL,
  r = 1,
  g = 2,
  b = 3,
  re = 4,
  nir = 5,
  return_class = c("ebimage", "terra"),
  resize = FALSE,
  has_white_bg = FALSE,
  plot = TRUE,
  nrow = NULL,
  ncol = NULL,
  max_pixels = 1e+05,
  parallel = FALSE,
  workers = NULL,
  verbose = TRUE,
  ...
)

\method{plot}{image_index}(x, type = c("raster", "density"), nrow = NULL, ncol = NULL, ...)
}
\arguments{
\item{img}{An \code{Image} object. Multispectral mosaics can be converted to an
\code{Image} object using \code{mosaic_as_ebimage()}.}

\item{index}{A character value (or a vector of characters) specifying the
target mode for conversion to a binary image. Use \code{\link[=pliman_indexes]{pliman_indexes()}} or the
\code{details} section to see the available indexes. Defaults to \code{NULL}
(normalized Red, Green, and Blue). You can also use "RGB" for RGB only,
"NRGB" for normalized RGB,  "MULTISPECTRAL" for multispectral indices
(provided NIR and RE bands are available) or "all" for all indexes. Users
can also calculate their own index using the band names, e.g., \code{index = "R+B/G"}.}

\item{r, g, b, re, nir}{The red, green, blue, red-edge, and near-infrared bands
of the image, respectively. Defaults to 1, 2, 3, 4, and 5, respectively. If
a multispectral image is provided (5 bands), check the order of bands,
which are frequently presented in the 'BGR' format.}

\item{return_class}{The class of object to be returned. If \verb{"terra} returns a
SpatRaster object with the number of layers equal to the number of indexes
computed. If \code{"ebimage"} (default) returns a list of \code{Image} objects, where
each element is one index computed.}

\item{resize}{Resize the image before processing? Defaults to \code{resize = FALSE}. Use \code{resize = 50}, which resizes the image to 50\% of the original
size to speed up image processing.}

\item{has_white_bg}{Logical indicating whether a white background is present.
If TRUE, pixels that have R, G, and B values equals to 1 will be considered
as NA. This may be useful to compute an image index for objects that have,
for example, a white background. In such cases, the background will not be
considered for the threshold computation.}

\item{plot}{Show image after processing?}

\item{nrow, ncol}{The number of rows or columns in the plot grid. Defaults to
\code{NULL}, i.e., a square grid is produced.}

\item{max_pixels}{integer > 0. Maximum number of cells to plot the index. If
\code{max_pixels < npixels(img)}, downsampling is performed before plotting the
index. Using a large number of pixels may slow down the plotting time.}

\item{parallel}{Processes the images asynchronously (in parallel) in separate
R sessions running in the background on the same machine. It may speed up
the processing time when \code{image} is a list. The number of sections is set
up to 70\% of available cores.}

\item{workers}{A positive numeric scalar or a function specifying the maximum
number of parallel processes that can be active at the same time.}

\item{verbose}{If \code{TRUE} (default) a summary is shown in the console.}

\item{...}{Additional arguments passed to \code{\link[=plot_index]{plot_index()}} for customization.}

\item{x}{An object of class \code{image_index}.}

\item{type}{The type of plot. Use \code{type = "raster"} (default) to produce a
raster plot showing the intensity of the pixels for each image index or
\code{type = "density"} to produce a density plot with the pixels' intensity.}
}
\value{
A list containing Grayscale images. The length will depend on the
number of indexes used.

A \code{NULL} object
}
\description{
\code{image_index()} Builds image indexes using Red, Green, Blue, Red-Edge, and NIR bands.

Generates a raster or density plot of the index values computed with
\code{image_index()}.
}
\details{
The following indexes are available in pliman.
\itemize{
\item RGB color space
}
\itemize{
\item \code{R} red
\item \code{G} green
\item \code{B} blue
\item \code{NR} normalized red \code{R/(R+G+B)}.
\item \code{NG} normalized green \code{G/(R+G+B)}
\item \code{NB} normalized blue \code{B/(R+G+B)}
\item \code{GB} green blue ratio \code{G/B}
\item \code{RB} red blue ratio \code{R/B}
\item \code{GR} green red ratio \code{G/R}
\item \code{BI} brightness Index \code{sqrt((R^2+G^2+B^2)/3)}
\item \code{BIM} brightness Index 2 \code{sqrt((R*2+G*2+B*2)/3)}
\item \code{SCI} Soil Colour Index \code{(R-G)/(R+G)}
\item \code{GLI} Green leaf index Vis Louhaichi et al. (2001) \code{(2*G-R-B)/(2*G+R+B)}
\item \code{HI} Primary colours Hue Index    (2*R-G-B)/(G-B)
\item \code{NDGRI} Normalized green red difference index (Tucker, 1979) \code{(G-R)/(G+R)}
\item \code{NDGBI} Normalized green blue difference index \code{(G-B)/(G+B)}
\item \code{NDRBI} Normalized red blue difference index \code{(R-B)/(R+B)}
\item \code{I}     R+G+B
\item \code{S}     \code{((R+G+B)-3*B)/(R+G+B)}
\item \code{L}     R+G+B/3
\item \code{VARI} A Visible Atmospherically Resistant Index \code{(G-R)/(G+R-B)}
\item \code{HUE} Overall Hue Index \code{atan(2*(B-G-R)/30.5*(G-R))}
\item \code{HUE2}  atan(2*(R-G-R)/30.5*(G-B))
\item \code{BGI}   B/G
\item \code{GRAY}	\code{0.299*R + 0.587*G + 0.114*B}
\item \code{GRAY2} \code{((R^2.2+(1.5*G)^2.2+(0.6*B)^2.2)/(1+1.5^2.2+0.6^2.2))^1/2.2}
\item \code{GLAI} \code{(25*(G-R)/(G+R-B)+1.25)}
\item \code{CI} Coloration Index \code{(R-B)/R}
\item \code{SAT} Overhall Saturation Index \code{(max(R,G,B) - min(R,G,B)) / max(R,G,B)}
\item \code{SHP} Shape Index \code{2*(R-G-B)/(G-B)}
\item \code{RI} Redness Index \code{R**2/(B*G**3)}
}
\itemize{
\item HSB color space
\item \code{DGCI} Dark Green Color Index, based on HSB color space \verb{60\\*((G - B) / (max(R, G, B) - min(R, G, B)))}
\item CIE-Lab color space
}
\itemize{
\item \verb{L*}: relative luminance \code{(0.2126 * R + 0.7152 * G + 0.0722 * B)}
\item \verb{a*}: \code{0.55*( (R - (0.2126 * R + 0.7152 * G + 0.0722 * B)) / (1.0 - 0.2126))}
}

When \code{type = "raster"} (default), the function calls \code{\link[=plot_index]{plot_index()}}
to create a raster plot for each index present in \code{x}. If \code{type = "density"},
a for loop is used to create a density plot for each index. Both types of
plots can be arranged in a grid controlled by the \code{ncol} and \code{nrow}
arguments.
}
\examples{
library(pliman)
img <- image_pliman("soybean_touch.jpg")
image_index(img, index = c("R, NR"))

# Example for S3 method plot()
library(pliman)
img <- image_pliman("sev_leaf.jpg")
# compute the index
ind <- image_index(img, index = c("R, G, B, NGRDI"), plot = FALSE)
plot(ind)

# density plot
plot(ind, type = "density")
}
\references{
Nobuyuki Otsu, "A threshold selection method from gray-level
histograms". IEEE Trans. Sys., Man., Cyber. 9 (1): 62-66. 1979.
\doi{10.1109/TSMC.1979.4310076}
}
\author{
Tiago Olivoto \email{tiagoolivoto@gmail.com}
}
