% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils_measures.R
\name{plot_lw}
\alias{plot_lw}
\title{Plot length and width lines on objects}
\usage{
plot_lw(
  object,
  col_length = "red",
  col_width = "green",
  lwd_length = 2,
  lwd_width = 2
)
}
\arguments{
\item{object}{An object computed with \code{\link[=analyze_objects]{analyze_objects()}}.}

\item{col_length}{The color of the length line. Default is \code{"red"}.}

\item{col_width}{The color of the width line. Default is \code{"green"}.}

\item{lwd_length}{The line width of the length line. Default is 2.}

\item{lwd_width}{The line width of the width line. Default is 2.}
}
\description{
This function plots the length and width lines given an \code{object} computed
with \code{\link[=analyze_objects]{analyze_objects()}}. The function does not call \code{plot.new}, so it must
be called after an image is plotted. This can be done either using, e.g.,
\code{plot(img)}, or \code{analyze_objects(..., plot = TRUE)}.
}
\details{
This function takes an object computed with \code{\link[=analyze_objects]{analyze_objects()}} and
plots the length and width lines of each object onto an image. The length
and width lines are calculated based on the position and orientation of the
object, and are plotted using the specified colors and line widths.
}
\examples{
img <- image_pliman("flax_leaves.jpg")
res <- analyze_objects(img, watershed = FALSE, show_contour = FALSE)
plot_lw(res)
}
