\name{plpoints}
\alias{plpoints}
\alias{pllines}

\title{Plot Points and Lines in the 'pl' system
}
\description{
  Low level functions for plotting point and lines
  based on the 'pl' paradigm.
}
\usage{
plpoints(x=NULL, y=NULL, type="p", plab=NULL, pch=NULL,
  pcol=NULL, col=NULL, lcol=NULL, lty=NULL, lwd=NULL, psize=NULL,
  csize = NULL, group = NULL, plargs = NULL, ploptions = NULL,
  marpar = NULL, xy = TRUE, ...)

pllines(x, y, type="l", ...)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{x, y}{coordinates for the horizontal and veritical axis,
    respectively. If \code{NULL}, they will be retrieved from
    \code{plargs$pldata}.
  }
  \item{type}{type of displaying points. See \code{?\link{points}}.}
  \item{plab}{labels for displaying points. Overrides labels provided by
    \code{plargs$pdata[["plab"]]}.
  }
  \item{pcol, col}{color for points. \code{col} is used if \code{pcol}
    is \code{NULL}
  }
  \item{lcol}{color for lines
  }
  \item{pch, psize, csize, lty, lwd}{... and \code{col} in \code{plpoints}:
    plotting character(s), relative size, median character expansion,
    and color for plotting points,
    and line type. %% to be used for \code{plpoints}.
    Overrides other settings, defined in \code{plargs}.
  }
  \item{group}{grouping of observations, used to determine \code{pch}
    and \code{col}
  }
  \item{plargs, ploptions}{result of \code{\link{pl.control}}, see Details
  }
  \item{marpar}{margin parameters, if already available.
    By default, they will be retieved from \code{ploptions}.
  }
  \item{xy}{logical: should the coordinates be obtained as in
    high level graphics? This is set to \code{FALSE} to save time and
    avoid complications, in case the user is sure that \code{x} and
    \code{y} are vectors rather than formulas or variable names.
  }
  \item{\dots}{absorbs extra arguments}
}
\value{
  \code{plsmooth} invisibly returns the data.frame needed for
  drawing the smooth line. The other functions return \code{NULL}
}
\details{
  For \code{plpoints}, the first arguments, \code{x} and \code{y}
  can be formulas, and an argument \code{data} can be given.
  These arguments then have the same meaning as in \code{\link{plyx}}.

  \code{plargs} and \code{ploptions} may be specified explicitly,
  but they are usually generated by calling \code{pl.control}.
}
  
\author{Werner A. Stahel
}

\seealso{\link{pl.control}
}
\examples{
plyx(Sepal.Width ~ Sepal.Length, data=iris, pcol=Species)

da <- aggregate(iris[,1:4], list(Species=iris$Species), mean)
plpoints(Sepal.Width ~ Sepal.Length, plargs=list(pldata=da),
  plab=da$Species, csize.pch=1, pcol=as.numeric(da$Species))
}

\keyword{aplot}

