\name{exp2d.C}
\alias{exp2d.C}

\title{
  2-d Exponential Hessian Data
}
\description{
  Generates 2-d classification data with two or three class labels,
  based on the Hessian data from a 2-d real-valued response
}
\usage{
exp2d.C(X, threed = TRUE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{
  \item{X}{
    a \code{matrix} or \code{data.frame} describing the design at which
    the response categories are desired
  }
  \item{threed}{
    a scalar \code{logical} indicating if the two or three-class version
    of the class labels should be returned.
  }
}
\details{
  The underlying real-valued response is governed by
  \deqn{Z(X)=x_1 * \exp(x_1^2-x_2^2).}{Z(X) = X1 * exp(-X1^2-X2^2).}
  Two class labels are generated by inspecting the sign of the sum of
  the eigenvalues of the Hessian (Broderick \& Gramacy, 2010).  This
  generates the first (-) and second (+) classes in a three-class
  function. A third class label (the default) may
  created from the first one where
  \code{X[,1] > 0} (Gramacy \& Polson, 2010)
}
\value{
  A vector of class labels of length \code{nrow(X)} is returned
}
\references{
  
  Broderick, T. and Gramacy, R. (2010). \dQuote{Classification and
    categorical inputs with treed Gaussian process models.} Tech.
  rep., University of Cambridge. ArXiv:0904.4891.
  
  Gramacy, R. and Polson, N. (2010).
  \dQuote{Particle learning of Gaussian process models for
    sequential design and optimization.}
  Tech. Rep. arXiv:0909.5262, University of Cambridge.
  
  \url{http://www.statslab.cam.ac.uk/~bobby/plgp.html}
}
\author{
Robert B. Gramacy, \email{bobby@statslab.cam.ac.uk}
}
\examples{
## The following demos use this data
\dontrun{
## Illustrates classification GPs on a simple 2-d exponential
## data generating mechanism
demo("plcgp_exp", ask=FALSE)

## Illustrates active learning via entropy with classification
## GPs on a simple 2-d exponential data generating mechanism
demo("plcgp_exp_entropy", ask=FALSE)
}
}
\keyword{ datagen }
