% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/raw_map.R
\name{raw_map}
\alias{raw_map}
\title{Plots a platemap with heatmap of raw values}
\usage{
raw_map(data, well, plate = 96)
}
\arguments{
\item{data}{Numerical values to be plotted}

\item{well}{Vector of well identifiers e.g "A01"}

\item{plate}{Number of wells in complete plate (96, 384 or 1536)}
}
\value{
ggplot plot
}
\description{
Converts numerical values and  well labels into multiple plate heatmaps
}
\examples{
df <- data.frame(vals = rnorm(1:384),
  well = num_to_well(1:384, plate = 384))

raw_map(data = df$vals,
        well = df$well,
        plate = 384)
}
