% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/well_to_num.R
\name{well_to_num}
\alias{well_to_num}
\title{Converts well labels to numbers}
\usage{
well_to_num(wells, style = "normal", plate = 96)
}
\arguments{
\item{wells}{Vector of well identifiers e.g "A01"}

\item{style}{Either normal, starting at the left hand column at each row
or in a snaking fashion. ('normal' or 'snake')}

\item{plate}{Number of wells in the complete plate (96 or 384)}
}
\value{
Vector of numbers
}
\description{
Converts alpha-numeric well labels to numbers corresponding to positions
within a microtitre plate. Either 96 or 384 well plate, in column-wise order
or in a column snaking pattern.
}
\examples{
well_to_num("A01")

well_to_num("P12", plate = 384)

well_to_num("P12", plate = 384, style = "snake")

wells <- c("A01", "A02", "A03")
well_to_num(wells)
}

