% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CreatePackageVignette.R
\name{CreatePackageVignette}
\alias{CreatePackageVignette}
\title{pkgnet Report as Vignette}
\usage{
CreatePackageVignette(pkg = ".",
  pkg_reporters = list(DependencyReporter$new(), FunctionReporter$new()),
  vignette_path = file.path(pkg, "vignettes", "pkgnet-report.Rmd"))
}
\arguments{
\item{pkg}{(string) path to root directory of package of interest}

\item{pkg_reporters}{(list) a list of initialized package reporters}

\item{vignette_path}{(string) The location of a file to store the output
vignette file at. Must be an .Rmd file. By default, this will be
'<pkg>/vignettes/pkgnet-report.Rmd' relative to the input to pkg}
}
\description{
Create pkgnet package report as an R Markdown vignette. This
   vignette can be rendered into a standard HTML vignette with the
   \code{\link[knitr:vignette_engines]{knitr::rmarkdown}} vignette engine
   into HTML vignettes upon package building. It is also compatible with
   #'    \code{\link[pkgdown:build_articles]{pkgdown}} sites. See the vignette
   \href{https://uptakeopensource.github.io/pkgnet/articles/publishing-reports.html}{
   "Publishing Your pkgnet Package Report"} for details about how to use this
   function, as well as
   \href{https://uptakeopensource.github.io/pkgnet-gallery/exhibits/pkgnet-vignette/pkgnet-vignette.html}{
   our example for pkgnet}.
}
