\name{checkWarning}
\alias{checkWarning}
\title{Extra Check Functions for RUnit}
\usage{
  checkWarning(expr, expected = NULL, msg = NULL)
}
\arguments{
  \item{expr}{an R expression}

  \item{expected}{expected value or regular expression
  pattern}

  \item{msg}{informative message to add to the error in
  case of failure}
}
\description{
  \code{checkWarning} checks if a warning is generated by
  an expression, and optionally follows an expected regular
  expression pattern.
}
\examples{
# check warnings
checkWarning({ warning('ah ah'); 3})
checkWarning({ warning('ah oh ah'); 3}, 'oh')
try( checkWarning(3) )
try( checkWarning({ warning('ah ah'); 3}, 'warn you') )
}

