% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_neighborhood.R
\name{neighborhood_graph}
\alias{neighborhood_graph}
\title{neighborhood_graph}
\usage{
neighborhood_graph(packages, level = 1L, type = "igraph",
  relation = c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances"),
  strict = FALSE, interconnect = TRUE, ignore = c("datasets", "utils",
  "grDevices", "graphics", "stats", "methods"))
}
\arguments{
\item{packages}{(non-empty character vector) Package names}

\item{level}{(positive integer, Default: 1L) Depth of recursive dependency}

\item{type}{(string, Default: "igraph") Graph object type. Either "network"
or "igraph"}

\item{relation}{(character vector) Types of graph edges. Must be a subset of
c("Depends", "Imports", "LinkingTo", "Suggests", "Enhances")}

\item{strict}{(logical, Default: TRUE) Whether to consider all packages
(alternately only 'relation' specific packages) when computing dependencies
for the next level}

\item{interconnect}{(flag, Default: TRUE) Whether to capture dependency among
packages (of a given level) of the next level (See examples)}

\item{ignore}{package names to ignore}
}
\value{
A network or igraph graph object
}
\description{
Obtain a network or igraph graph object of dependencies and
  reverse dependencies of packages at a given depth of recursion
}
\examples{
# explore first level dependencies
pkggraph::init(local = TRUE)
pkggraph::neighborhood_graph("caret")

# explore second level dependencies of class network
pkggraph::neighborhood_graph("caret", level = 2, type = "network")

# get 'imports' specific neighborhood of 'mlr' package with strict = TRUE
neighborhood_graph("mlr"
                   , level        = 2
                   , strict       = TRUE
                   , interconnect = FALSE
                   , relation     = "Imports")

# get 'imports' specific neighborhood of 'mlr' package with strict = FALSE
neighborhood_graph("mlr"
                   , level        = 2
                   , strict       = FALSE
                   , interconnect = FALSE
                   , relation     = "Imports")
}
\seealso{
\code{\link{get_neighborhood}},
  \code{\link{make_neighborhood_graph}}
}
\author{
Srikanth KS
}
