test_that("parse failures include file name", {
  skip_if_not_installed("rlang", "0.99")
  pkg <- local_pkgdown_site("assets/reference-fail")
  expect_snapshot(build_reference(pkg), error = TRUE)
})

test_that("examples_env runs pre and post code", {
  dst_path <- withr::local_tempdir()
  dir_create(path(dst_path, "reference"))

  pkg <- list(
    package = "test",
    src_path = test_path("assets/reference-pre-post"),
    dst_path = dst_path
  )

  env <- local(examples_env(pkg))
  expect_equal(env$a, 2)
})

test_that("examples_env sets width", {
  pkg <- local_pkgdown_site(test_path("assets/reference"), "
    code:
      width: 50
  ")

  examples_env(pkg)
  expect_equal(getOption("width"), 50)
})


test_that("test usage ok on rendered page", {
  pkg <- local_pkgdown_site(test_path("assets/reference"))
  expect_output(build_reference(pkg, topics = "c"))
  html <- xml2::read_html(file.path(pkg$dst_path, "reference", "c.html"))
  expect_equal(xpath_text(html, "//div[@id='ref-usage']", trim = TRUE), "c()")
  clean_site(pkg)

  pkg <- local_pkgdown_site(test_path("assets/reference"), "
      template:
        bootstrap: 5
    ")
  expect_output(init_site(pkg))
  expect_output(build_reference(pkg, topics = "c"))
  html <- xml2::read_html(file.path(pkg$dst_path, "reference", "c.html"))
  # tweak_anchors() moves id into <h2>
  expect_equal(xpath_text(html, "//div[h2[@id='ref-usage']]/div", trim = TRUE), "c()")
})

test_that(".Rd without usage doesn't get Usage section", {
  pkg <- local_pkgdown_site(test_path("assets/reference"))
  expect_output(build_reference(pkg, topics = "e"))
  html <- xml2::read_html(file.path(pkg$dst_path, "reference", "e.html"))
  expect_equal(xpath_length(html, "//div[@id='ref-usage']"), 0)
  clean_site(pkg)

  pkg <- local_pkgdown_site(test_path("assets/reference"), "
      template:
        bootstrap: 5
    ")
  expect_output(init_site(pkg))
  expect_output(build_reference(pkg, topics = "e"))
  html <- xml2::read_html(file.path(pkg$dst_path, "reference", "e.html"))
  # tweak_anchors() moves id into <h2>
  expect_equal(xpath_length(html, "//div[h2[@id='ref-usage']]"), 0)
})
