% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/envir_deps.R
\name{deps}
\alias{deps}
\title{Get environment dependency object}
\usage{
deps(pkg, exported_only = FALSE)
}
\arguments{
\item{pkg}{A character vector of the environments to explore. Should be on the \link[base]{search} path. Cannot be \code{base}.}

\item{exported_only}{Boolean. Whether to include non-exported functions.}
}
\value{
An object of class \code{pkgdepR}.
}
\description{
This function creates an object of class \code{pkgdepR}, representing the network of function calls between one or more packages.
}
\details{
An object of class \code{pkgdepR} is a list with three named objects:
\describe{
 \item{\strong{\code{funs}}}{: a data frame describing the functions. Contains columns \code{id}, \code{label}, \code{package}, \code{exported}, \code{group}, and \code{name}.}|
 \item{\strong{\code{links}}}{: a data frame containing the linkages between functions. Contains columns \code{from} and \code{to}.}|
 \item{\strong{\code{pkg}}}{: a character vector containing the packages explored.}|
}
}
\examples{
library(pkgdepR)
deps(pkg = "pkgdepR")
}
