% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/m278hlair.R
\name{m278hlair}
\alias{m278hlair}
\title{Minenergo-278. Heat losses of overhead pipeline segment}
\usage{
m278hlair(
  t1 = 110,
  t2 = 60,
  t0 = 5,
  insd1 = 0.1,
  insd2 = insd1,
  d1 = 0.25,
  d2 = d1,
  lambda1 = 0.09,
  lambda2 = 0.07,
  k1 = 1,
  k2 = k1,
  lambda0 = 26,
  len = 1,
  duration = 1
)
}
\arguments{
\item{t1}{temperature of heat carrier (water) inside the supplying pipe, [\emph{°C}].
Type: \code{\link{assert_double}}.}

\item{t2}{temperature of heat carrier (water) inside the returning pipe, [\emph{°C}].
Type: \code{\link{assert_double}}.}

\item{t0}{temperature of environment, [\emph{°C}]. In case of overhead laying this is
the ambient temperature. Type: \code{\link{assert_double}}.}

\item{insd1}{thickness of the insulator which covers the supplying pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{insd2}{thickness of the insulator which covers the returning pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{d1}{external diameter of supplying pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{d2}{external diameter of returning pipe, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{lambda1}{thermal conductivity of insulator which covers the supplying pipe
[\emph{W/m/°C}]. Type: \code{\link{assert_double}}.}

\item{lambda2}{thermal conductivity of insulator which covers the returning pipe
[\emph{W/m/°C}]. \code{\link{assert_double}}.}

\item{k1}{technical condition factor for insulator of supplying pipe, [].
Type: \code{\link{assert_double}}.}

\item{k2}{technical condition factor for insulator of returning pipe, [].
Type: \code{\link{assert_double}}.}

\item{lambda0}{thermal conductivity of environment, [\emph{W/m/°C}]. In case of overhead
laying this is the thermal conductivity of open air.
Type: \code{\link{assert_double}}.}

\item{len}{length of pipeline segment, [\emph{m}].
Type: \code{\link{assert_double}}.}

\item{duration}{duration of heat flux emittance, [\emph{hour}]. Type: \code{\link{assert_double}}.}
}
\value{
Heat flux emitted by pipeline segment during \code{duration}, [\emph{kcal}].
 If \code{len} of pipeline segment is 1 \emph{m} and \code{duration} of
 heat flux emittance is set to 1 \emph{hour} then the return value is equal
 to that in [\emph{kcal/m/h}] units and so comparable with values of
 heat flux listed in
 \href{http://docs.cntd.ru/document/902148459}{Minenergo Order 325}.
 Type: \code{\link{assert_double}}.
}
\description{
Calculate values of heat flux emitted by overhead pipeline segment
 (surrounded by air) as a function of construction, operation,
 and technical condition  specifications according to
 Appendix 5.1 of \href{http://www.complexdoc.ru/ntdtext/547103/}{Minenergo Method 278}.

 This type of calculations is usually made on design stage of district
 heating network (where water is a heat carrier) and is closely related to
 building codes and regulations.
}
\details{
Details on using \code{k1} and \code{k2} are the same as for
  \code{\link{m278hlcha}}.
}
\examples{
 m278hlair()
 # [1] 138.7736

}
\seealso{
Other Minenergo: 
\code{\link{m278hlcha}()},
\code{\link{m278hlund}()},
\code{\link{m278insdata}},
\code{\link{m278inshcm}()},
\code{\link{m278soildata}},
\code{\link{m325beta}()},
\code{\link{m325dropt}()},
\code{\link{m325nhldata}},
\code{\link{m325nhl}()},
\code{\link{m325testbench}}
}
\concept{Minenergo}
