% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pin.R
\name{pin_info}
\alias{pin_info}
\title{Pin Info}
\usage{
pin_info(
  name,
  board = NULL,
  extended = TRUE,
  metadata = TRUE,
  signature = FALSE,
  ...
)
}
\arguments{
\item{name}{The exact name of the pin to match when searching.}

\item{board}{The board name used to find the pin.}

\item{extended}{Should additional board-specific information be shown?}

\item{metadata}{Should additional pin-specific information be shown?}

\item{signature}{Should a signature to identify this pin be shown?}

\item{...}{Additional parameters.}
}
\description{
Retrieve information for a given pin.
}
\examples{
library(pins)

# define local board
board_register_local(cache = tempfile())

# cache the mtcars dataset
pin(mtcars)

# print pin information
pin_info("mtcars")

}
