% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pim-class.R
\docType{class}
\name{pim-class}
\alias{pim-class}
\title{Class pim}
\description{
This class contains the fitting information resulting from a call to
\code{\link{pim}}.
}
\section{Slots}{

\describe{
\item{\code{formula}}{The \code{\link{pim.formula}} object used in the fit}

\item{\code{coef}}{a numeric vector with the fitted coefficients}

\item{\code{vcov}}{a numeric matrix containing the variance-covariance matrix 
of the fitted coefficients}

\item{\code{penv}}{a \code{\link{pim.environment}} object containing the 
data used to fit this}

\item{\code{fitted}}{a numeric vector containing the raw fitted}

\item{\code{link}}{a character vector describing the used link function}

\item{\code{estimators}}{a list with the elements \code{coef} and \code{vcov},
containing either a character value with the name of the used estimator,
or the function itself.}

\item{\code{model.matrix}}{If \code{keep.data} is set to \code{TRUE} 
while calling \code{\link{pim}} the original model matrix. 
Otherwise an empty matrix with 0 rows and columns.}

\item{\code{response}}{If \code{keep.data} is set to \code{TRUE} 
while calling \code{\link{pim}} the original response vector.
Otherwise an empty numeric vector.}

\item{\code{keep.data}}{a logical value indicating whether the original
data is kept in the object. This is set using the argument
\code{keep.data} of the function \code{\link{pim}}.
\code{model} a character value with the value "difference",
"marginal", "regular" or "customized", indicating which
type of pim model has been fitted.}
}}

