## ---- include = FALSE---------------------------------------------------------
knitr::opts_chunk$set(
  collapse = TRUE,
  comment = "#>"
)

## ----setup--------------------------------------------------------------------
library(pillar)

## -----------------------------------------------------------------------------
options(digits = 3)
c(1.2345, 12.345, 123.45, 1234.5, 12345)
pillar(c(1.2345, 12.345, 123.45, 1234.5, 12345))

## -----------------------------------------------------------------------------
c(1, 1.00001)
pillar(c(1, 1.00001))

## -----------------------------------------------------------------------------
c(123, 123.45, 567.89)
pillar(c(123, 123.45, 567.89))

## -----------------------------------------------------------------------------
options(digits = 7)
options(pillar.sigfig = 7)
c(1.2345, 12.345, 123.45, 1234.5, 12345)
pillar(c(1.2345, 12.345, 123.45, 1234.5, 12345))

## -----------------------------------------------------------------------------
options(digits = 7)
options(pillar.sigfig = 7)
c(1.2345, 12.3456, 123.4567, 1234.5678, 12345.6789)
pillar(c(1.2345, 12.3456, 123.4567, 1234.5678, 12345.6789))

## -----------------------------------------------------------------------------
num(c(1.2345, 12.345, 123.45, 1234.5, 12345), digits = 2)

## -----------------------------------------------------------------------------
123456789012
123456789012.3
1234567890123
1234567890123.4
options(scipen = 1)
1234567890123
12345678901234
12345678901234.5

## -----------------------------------------------------------------------------
pillar(123456789012)
pillar(123456789012.3)
pillar(1234567890123)
pillar(1234567890123.4)
options(pillar.max_dec_width = 14)
pillar(1234567890123)
pillar(12345678901234)
pillar(12345678901234.5)

## -----------------------------------------------------------------------------
num(12345678901234567, notation = "dec")
num(12345678901234567, notation = "sci")
num(12345678901234567, notation = "eng")
num(12345678901234567, notation = "si")

