% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/basicPieceGrobs.R
\name{basicPieceGrobs}
\alias{basicPieceGrobs}
\alias{basicPieceGrob}
\alias{pyramidTopGrob}
\alias{previewLayoutGrob}
\title{Piece Grob Functions}
\usage{
basicPieceGrob(piece_side, suit, rank, cfg = pp_cfg())

pyramidTopGrob(piece_side, suit, rank, cfg = pp_cfg())

previewLayoutGrob(piece_side, suit, rank, cfg = pp_cfg())
}
\arguments{
\item{piece_side}{A string with piece and side separated by a underscore e.g. "coin_face"}

\item{suit}{Number of suit (highest rank starting from 1).
The number above the total number of suits is the neutral "unsuit".
and the next number above that is "no suits".}

\item{rank}{Number of rank (lowest rank starting from 1)}

\item{cfg}{Piecepack configuration list or \code{pp_cfg} object,}
}
\description{
Default functions \code{grid.piece} uses to create \code{grid} 
graphical \code{grob} objects.
}
\examples{

 if (require("grid")) {
    cfg <- pp_cfg(list(invert_colors=TRUE))

    pushViewport(viewport(width=unit(2, "in"), height=unit(2, "in")))
    grid.draw(basicPieceGrob("tile_face", suit=1, rank=3))
    popViewport()

    grid.newpage()
    pushViewport(viewport(width=unit(0.75, "in"), height=unit(0.75, "in")))
    grid.draw(basicPieceGrob("coin_back", suit=2, rank=0, cfg=cfg))
    popViewport()

    grid.newpage()
    pushViewport(viewport(width=unit(0.75, "in"), height=unit(0.75, "in")))
    grid.draw(pyramidTopGrob("pyramid_top", suit=3, rank=5))
    popViewport()

    grid.newpage()
    pushViewport(viewport(width=unit(6, "in"), height=unit(6, "in")))
    grid.draw(previewLayoutGrob("preview_layout", suit=5, rank=0, cfg=cfg))
    popViewport()
 }
}
