#----------------------------------------------------------------------------------#
# Package: picasso                                                                  #
# glasso.stoc(): Stochastic actic set identification                               #
# Author: Xingguo Li                                                               #
# Email: <xingguo.leo@gmail.com>                                                   #
# Date: Aug 9th, 2014                                                              #
# Version: 0.1.0                                                                   #
#----------------------------------------------------------------------------------#

glasso.stoc <- function(Y, X, gr, gr.n, gr.size, lambda, nlambda, n, d, max.ite, prec, verbose)
{
  if(verbose==TRUE)
    cat("Group regularization via stochastic actic set identification and coordinate descent\n")
  S = colSums(X^2)
  beta = matrix(0,nrow=d,ncol=nlambda)
  beta.intcpt = rep(0,nlambda)
  gr.size.act = rep(0,nlambda)
  ite.lamb = rep(0,nlambda)
  gr1 = rep(0, gr.n)
  for(i in 1:gr.n){
    gr1[i] = gr[[i]][1]-1
  }
  str=.C("picasso_glasso_stoc", as.double(Y), as.double(X), as.double(S), 
         as.double(beta), as.double(beta.intcpt), as.integer(n), as.integer(d), 
         as.integer(ite.lamb), as.integer(gr.size.act),as.integer(gr1),as.integer(gr.n),
         as.integer(gr.size), as.double(lambda), as.integer(nlambda), 
         as.integer(max.ite), as.double(prec), PACKAGE="picasso")
  beta.list = vector("list", nlambda)
  for(i in 1:nlambda){
    beta.i = unlist(str[4])[((i-1)*d+1):(i*d)]
    beta.list[[i]] = beta.i
  }
  beta.intcpt = unlist(str[5])
  ite.int = unlist(str[8])
  ite = list()
  ite[[1]] = ite.int
  gr.size.act = unlist(str[9])
  return(list(beta=beta.list, intcpt = beta.intcpt, ite=ite, gr.size.act = gr.size.act))
}
