% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is.na.piar_index.R
\name{is.na.piar_index}
\alias{is.na.piar_index}
\alias{anyNA.piar_index}
\title{Missing values in a price index}
\usage{
\method{is.na}{piar_index}(x)

\method{anyNA}{piar_index}(x, recursive = FALSE)
}
\arguments{
\item{x}{A price index, as made by, e.g., \code{\link[=elemental_index]{elemental_index()}}.}

\item{recursive}{Check if \code{x} also has missing percent-change
contributions. By default only index values are checked for missingness.}
}
\value{
\code{is.na()} returns a logical matrix, with a row for each level of \code{x} and a
columns for each time period, that indicates which index values are missing.

\code{anyNA()} returns \code{TRUE} if any index values are missing, or percent-change
contributions (if \code{recursive = TRUE}).
}
\description{
Identify missing values in a price index.
}
\examples{
index <- as_index(matrix(c(1, 2, 3, NA, 5, NA), 2))

anyNA(index)
is.na(index)

# Carry forward imputation

index[is.na(index)] <- 1
index

}
\seealso{
Other index methods: 
\code{\link{[.piar_index}()},
\code{\link{aggregate.piar_index}},
\code{\link{as.data.frame.piar_index}()},
\code{\link{as.ts.piar_index}()},
\code{\link{chain}()},
\code{\link{contrib}()},
\code{\link{head.piar_index}()},
\code{\link{levels.piar_index}()},
\code{\link{mean.piar_index}},
\code{\link{merge.piar_index}()},
\code{\link{split.piar_index}()},
\code{\link{stack.piar_index}()},
\code{\link{time.piar_index}()},
\code{\link{window.piar_index}()}
}
\concept{index methods}
