% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/age.R
\name{age_from_dates}
\alias{age_from_dates}
\title{age from birth and reference dates}
\usage{
age_from_dates(birth_date, ref_date = Sys.Date(), unit = c("year", "month",
  "day"))
}
\arguments{
\item{birth_date}{Date of birth, either as a \code{Date} or something which
will be converted to a \code{Date}}

\item{ref_date}{Date at which to calculate age, defaults to current date,
either as a \code{Date} or something which will be converted to a
\code{Date}}

\item{unit}{character of length, one of "year" or "day".}
}
\value{
integer vector
}
\description{
Calculate age at time of reference date, based on birth date, rounded to the
given unit. These are designed for physiologic estimations, not for accuracy.
The dates can be given as anything which can be coerced into a \code{Date}.
}
\examples{
age_from_dates("2014-11-08", "2014-12-31", unit = "day")
age_from_dates("1981-07-09", "2014-06-29", unit = "year")
}
\references{
https://stackoverflow.com/questions/31126726/efficient-and-accurate-age-calculation-in-years-months-or-weeks-in-r-given-b
}
