% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim-phybreak.R
\name{sim.phybreak}
\alias{sim.phybreak}
\title{Outbreak simulation.}
\usage{
sim.phybreak(obsize = 50, popsize = NA, samplesperhost = 1, R0 = 1.5,
  shape.gen = 10, mean.gen = 1, shape.sample = 10, mean.sample = 1,
  additionalsampledelay = 0, wh.model = 3, wh.slope = 1, mu = 1e-04,
  sequence.length = 10000, output.class = c("phybreakdata", "obkData"))
}
\arguments{
\item{obsize}{The outbreak size (number of cases) to obtain. If \code{obsize = NA}, \code{popsize} should be provided.}

\item{popsize}{The population size in which to simulate. If it is not defined (default), 
an optimal population size will be chosen based on R0 and obsize. Be aware that choosing a \code{popsize} and
an \code{obsize} can severely increase the simulation time, depending on \code{R0}.}

\item{samplesperhost}{Number of samples to be taken per host, either a vector or a single number.}

\item{R0}{The basic reproduction ratio used for simulation. The offspring distribution is Poisson.}

\item{shape.gen}{The shape parameter of the gamma-distributed generation interval.}

\item{mean.gen}{The mean generation interval.}

\item{shape.sample}{The shape parameter of the gamma-distributed sampling interval.}

\item{mean.sample}{The mean sampling interval (for the first sample of each host).}

\item{additionalsampledelay}{Sampling intervals since first sampling times of each host. Values in this vector will be 
used first for all additional samples of host 1, then of host 2, etc.}

\item{wh.model}{The model for within-host pathogen dynamics (effective pathogen population size = 
N*gE = actual population size * pathogen generation time), used to simulate coalescence events. Options are:
\enumerate{
  \item Effective size = 0, so coalescence occurs 'just before' transmission, in the infector
  \item Effective size = Inf, so coalescence occurs 'just after' infection, in the infectee
  \item Effective size at time t after infection = wh.slope * t
}}

\item{wh.slope}{Within-host increase of effective population size, used if \code{wh.model = 3}.}

\item{mu}{Expected number of mutations per nucleotide per unit of time along each lineage.}

\item{sequence.length}{Number of available nucleotides for mutations.}

\item{output.class}{Class of the simulation output. If package \pkg{OutbreakTools} is available, it is possible to choose
class \code{'obkData'}}
}
\value{
The simulation output, either as an object of class \code{'phybreakdata'} with sequences (class \code{'phyDat'}) and 
  sampling times (which would be the observations), and infection times, infectors, and phylogenetic tree 
  of class \code{\link[ape]{phylo}}; 
  or as an object of class \code{'obkData'} (package \pkg{OutbreakTools}), containing the outbreak data in the following slots:
  \describe{
    \item{individuals}{a \code{data.frame} with individual labels as row names, a vector \code{infector},
      and a vector \code{date} containing the infection times (starting 01-01-2000)
    }
    \item{dna}{an object of class \code{'obkSequences'}, with SNP data in \code{dna} and sampling times
      in \code{meta$date}
    }
    \item{trees}{an object of class \code{\link[ape]{multiphylo}}, containing a single tree of class \code{\link[ape]{phylo}}}
  }
}
\description{
Simulate outbreaks of class \code{'phybreakdata'}, with the outbreak model of \pkg{phybreak}.
}
\examples{
simulation <- sim.phybreak()
}
\references{
\href{http://dx.doi.org/10.1371/journal.pcbi.1005495}{Klinkenberg et al. (2017)} Simultaneous 
  inference of phylogenetic and transmission trees in infectious disease outbreaks. 
  \emph{PLoS Comput Biol}, \strong{13}(5): e1005495.
}
\author{
Don Klinkenberg \email{don@xs4all.nl}
}
