% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.peaks.r
\name{valleys}
\alias{valleys}
\alias{valleys.default}
\alias{valleys.numeric}
\alias{valleys.generic_spct}
\alias{valleys.source_spct}
\alias{valleys.response_spct}
\alias{valleys.filter_spct}
\alias{valleys.reflector_spct}
\alias{valleys.cps_spct}
\alias{valleys.generic_mspct}
\title{Valleys or local minima}
\usage{
valleys(x, span, ignore_threshold, strict, ...)

\method{valleys}{default}(x, span, ignore_threshold, strict, ...)

\method{valleys}{numeric}(x, span = 5, ignore_threshold, strict = TRUE, ...)

\method{valleys}{generic_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, ...)

\method{valleys}{source_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, unit.out = getOption("photobiology.radiation.unit", default
  = "energy"), ...)

\method{valleys}{response_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, unit.out = getOption("photobiology.radiation.unit", default
  = "energy"), ...)

\method{valleys}{filter_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, filter.qty = getOption("photobiology.filter.qty", default =
  "transmittance"), ...)

\method{valleys}{reflector_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, ...)

\method{valleys}{cps_spct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, ...)

\method{valleys}{generic_mspct}(x, span = 5, ignore_threshold = 0,
  strict = TRUE, ...)
}
\arguments{
\item{x}{an R object}

\item{span}{a peak is defined as an element in a sequence which is greater
than all other elements within a window of width span centered at that
element. The default value is 3, meaning that a peak is bigger than both of
its neighbors. Default: 3.}

\item{ignore_threshold}{numeric value between 0.0 and 1.0 indicating the
relative size compared to talelst peakthreshold below which valleys will be
ignored.}

\item{strict}{logical flag: if TRUE, an element must be strictly greater than
all other values in its window to be considered a peak. Default: TRUE.}

\item{...}{ignored}

\item{unit.out}{character One of "energy" or "photon"}

\item{filter.qty}{character One of "transmittance" or "absorbance"}
}
\value{
A subset of \code{x} with rows corresponding to local minima.
}
\description{
Function that returns a subset of an R object with observations corresponding
to local maxima.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default function usable on numeric vectors.

\item \code{numeric}: Default function usable on numeric vectors.

\item \code{generic_spct}: Method for "generic_spct" objects.

\item \code{source_spct}: Method for "source_spct" objects.

\item \code{response_spct}: Method for "response_spct" objects.

\item \code{filter_spct}: Method for "filter_spct" objects.

\item \code{reflector_spct}: Method for "reflector_spct".

\item \code{cps_spct}: Method for "cps_spct" objects.

\item \code{generic_mspct}: Method for "generic_mspct" objects.
}}

\examples{
valleys(sun.spct)

}
\seealso{
Other peaks and valleys functions: \code{\link{find_peaks}},
  \code{\link{get_peaks}}, \code{\link{peaks}}
}
