% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spct.tag.R
\name{tag}
\alias{tag}
\alias{tag.default}
\alias{tag.generic_spct}
\alias{tag.generic_mspct}
\title{Tag a spectrum}
\usage{
tag(x, ...)

\method{tag}{default}(x, ...)

\method{tag}{generic_spct}(x, w.band = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = TRUE, short.names = TRUE, byref = FALSE, ...)

\method{tag}{generic_mspct}(x, w.band = NULL,
  wb.trim = getOption("photobiology.waveband.trim", default = TRUE),
  use.hinges = TRUE, short.names = TRUE, byref = FALSE, ...)
}
\arguments{
\item{x}{an R object}

\item{...}{not used in current version}

\item{w.band}{waveband or list of waveband objects The waveband(s) determine
the region(s) of the spectrum that are tagged}

\item{wb.trim}{logical Flag telling if wavebands crossing spectral data
boundaries are trimmed or ignored}

\item{use.hinges}{logical Flag indicating whether to use hinges to reduce
interpolation errors}

\item{short.names}{logical Flag indicating whether to use short or long names
for wavebands}

\item{byref}{logical Flag indicating if new object will be created \emph{by
reference} or \emph{by copy} of \code{x}}
}
\description{
Spectra are tagged by adding variables and attributes containing color
definitions, labels, and a factor following the wavebands given in
\code{w.band}.
}
\section{Methods (by class)}{
\itemize{
\item \code{default}: Default method for generic

\item \code{generic_spct}: Tag one of \code{generic_spct}, and derived classes including
\code{source_spct}, \code{filter_spct}, \code{reflector_spct},
\code{object_spct}, and \code{response_spct}.

\item \code{generic_mspct}: Tag one of \code{generic_mspct}, and derived classes including
\code{source_mspct}, \code{filter_mspct}, \code{reflector_mspct},
\code{object_mspct}, and \code{response_mspct}.
}}

\note{
\code{NULL} as \code{w.band} argument does not add any new tags,
  instead it removes existing tags if present. \code{NA}, the default, as
  \code{w.band} argument removes existing waveband tags if present and
  sets the \code{wl.color} variable. If a waveband object or a list of
  wavebands is supplied as argument then tagging is based on them, and
  \code{wl.color} is also set.
}
\examples{

tag(sun.spct)
tag(sun.spct, list(A = waveband(c(300,3005))))

}
\seealso{
Other tagging and related functions: \code{\link{is_tagged}},
  \code{\link{untag}}, \code{\link{wb2rect_spct}},
  \code{\link{wb2spct}}, \code{\link{wb2tagged_spct}}
}
