% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mspct.mean.se.r
\name{s_mean_se}
\alias{s_mean_se}
\alias{s_mean_se.default}
\alias{s_mean_se.generic_spct}
\alias{s_mean_se.filter_mspct}
\alias{s_mean_se.source_mspct}
\alias{s_mean_se.response_mspct}
\alias{s_mean_se.reflector_mspct}
\alias{s_mean_se.calibration_mspct}
\alias{s_mean_se.cps_mspct}
\alias{s_mean_se.raw_mspct}
\title{Mean and standard error from collection of spectra}
\usage{
s_mean_se(x, na.rm, mult, ...)

\method{s_mean_se}{default}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{generic_spct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{filter_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{source_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{response_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{reflector_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{calibration_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{cps_mspct}(x, na.rm = FALSE, mult = 1, ...)

\method{s_mean_se}{raw_mspct}(x, na.rm = FALSE, mult = 1, ...)
}
\arguments{
\item{x}{An R object.}

\item{na.rm}{logical A value indicating whether NA values should be stripped
before the computation proceeds.}

\item{mult}{numeric number of multiples of standard error.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
If \code{x} is a collection spectral of objects, such as a
  \code{"filter_mspct"} object, the returned object belongs to the same class
  as the members of the collection, such as \code{"filter_spct"}, containing
  the summary spectrum, with variables with names tagged for summaries other
  than mean or median.
}
\description{
Method to compute the "parallel" mean and the SEM. The spectral
values are summarised across members of a collection of spectra or of a
spectral object containing multiple spectra in long form.
}
\details{
Method specializations compute the  mean and SEM at
  each wavelength across a group of spectra stored in an object of one of the
  classes defined in package 'photobiology'. Omission of NAs is done
  separately at each wavelength. Interpolation is not applied, so all spectra
  in \code{x} must share the same set of wavelengths. An error is triggered
  if this condition is nor fulfilled. The value passed as argument to `mult`
}
\note{
Objects of classes \code{raw_spct} and \code{cps_spct} can contain data
  from multiple scans in multiple variables or "columns". The parallel
  summaries' methods accept as arguments objects of these classes only if
  spectra contain data for a single spectrometer scan. In the case of
  \code{cps_spct} objects, a single column can also contain data from
  multiple scans spliced into a single variable.
}
\section{Deepest Curves}{
 Parallel summaries differ fundamentally from the
  "deepest curves" obtained through functional data analysis (FDA) in that in
  functional data analysis one of the input curves is returned as the deepest
  one based on a decision criterion. In contrast the parallel summaries from
  package 'photobioloy' return one or more "fictional" curves different to
  any of those passed as inputs. This curve is constructed from independent
  summaries at each wavelength value.
}

\examples{
s_mean_se(sun_evening.mspct)

}
\seealso{
See \code{\link[base]{mean}} for the \code{mean()} method to
  compute the mean and \code{\link{sd}} for the method used to compute the
  standard error of the mean.
}
