\name{zeros}
\alias{zeros}
\title{
Zero Vector/Matrix
}
\description{
Returns a vector or 2D matrix of zeros of the same shape as the input.
}
\usage{
zeros (x,y=0)
}
\arguments{
  \item{x}{A scalar, vector, or two dimensional matrix.} 
  \item{y}{An optional parameter to create a 2D matrix.} 
}
\details{
If a scalar value is given, a vector of that many zeros is returned. If the y parameter is also specified, a matrix is returned with x rows and y columns. 

If a vector is given, a vector of zeros of the same length is returned. 

If a 2D matrix or dataframe is given, a matrix of zeros with the name number of rows and columns is returned.
}
\author{
Santiago Barreda <sbarreda@ualberta.ca>
}
\examples{

## A vector 
zeros (5)
## A matrix
zeros (5, 3)

## Copy an existing vector
zeros (1:10)

## Copy an existing matrix
samplematrix = 1:10 %*% t(2:11)
zeros (samplematrix)

}





