% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/phoenix_hepatic.R
\name{phoenix_hepatic}
\alias{phoenix_hepatic}
\title{Phoenix Hepatic Score}
\usage{
phoenix_hepatic(
  bilirubin = NA_real_,
  alt = NA_real_,
  data = parent.frame(),
  ...
)
}
\arguments{
\item{bilirubin}{numeric vector; units of mg/dL}

\item{alt}{alanine aminotransferase; a numeric vector; units of IU/L}

\item{data}{a \code{list}, \code{data.frame}, or \code{environment} containing the input vectors}

\item{...}{pass through}
}
\value{
a integer vector with values 0 or 1

As with all other Phoenix organ system scores, missing values in the data
set will map to a score of zero - this is consistent with the development of
the criteria.
}
\description{
Apply the Phoenix Hepatic scoring based on total bilirubin and ALT.
}
\section{Phoenix Hepatic Scoring}{

1 point for total bilirubin greater or equal to 4 mg/dL and/or ALT strictly
greater than 102 IU/L.
}

\examples{

# using the example sepsis data set
hep_example <- sepsis[c("pid", "bilirubin", "alt")]
hep_example$score <- phoenix_hepatic(bilirubin, alt, sepsis)
hep_example

# example data set with all possilbe hepatic scores
DF <- expand.grid(bil = c(NA, 3.2, 4.0, 4.3), alt = c(NA, 99, 102, 106))
phoenix_hepatic(bilirubin = bil, alt = alt, data = DF)
}
\references{
See reference details in \code{\link{phoenix-package}} or by calling
\code{citation('phoenix')}.
}
\seealso{
\itemize{
  \item \code{\link{phoenix}} for generating the diagnostic Phoenix
    Sepsis score based on the four organ systems:
    \itemize{
      \item \code{\link{phoenix_cardiovascular}},
      \item \code{\link{phoenix_coagulation}},
      \item \code{\link{phoenix_neurologic}},
      \item \code{\link{phoenix_respiratory}},
    }
  \item \code{\link{phoenix8}} for generating the diagnostic Phoenix 8
    Sepsis criteria based on the four organ systems noted above and
    \itemize{
      \item \code{\link{phoenix_endocrine}},
      \item \code{\link{phoenix_immunologic}},
      \item \code{\link{phoenix_renal}},
      \item \code{\link{phoenix_hepatic}},
    }
}

\code{vignette('phoenix')} for more details and examples.
}
