% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DFSource.R
\name{getElem.DFSource}
\alias{getElem.DFSource}
\title{Obtain the current row of the content of a DFSource}
\usage{
\method{getElem}{DFSource}(x)
}
\arguments{
\item{x}{A DFSource object}
}
\value{
A list with the current row in the content of a DFSource object.
The current row index is the position in the DFSource object.
}
\description{
Using the position field of x to indicate the index of the current row, we
retrieve the current row of the content of a DFSource. This function is
mainly used by the VCorpus function.
}
\examples{
library(tm)
df=data.frame(id=1:3,text=c("First text","Second text","Third text"),
              title=c("N1","N2","N3"))
getElem(stepNext(DFSource(df)))
}
