% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/I_optim.R
\name{I_optim}
\alias{I_optim}
\alias{I_optimx}
\title{Interface of unified optimization functions.}
\usage{
I_optim(prior, FUN, y, t, method = "BFGS", ..., use.cpp = FALSE)

I_optimx(prior, FUN, y, t, method, verbose = FALSE, ..., use.cpp = FALSE)
}
\arguments{
\item{prior}{A vector of initial values for the parameters for which optimal
values are to be found. \code{prior} is suggested giving a column name.}

\item{FUN}{Fine curve fitting function for goal function \code{\link[=f_goal]{f_goal()}}.}

\item{y}{Numeric vector, vegetation index time-series}

\item{t}{Numeric vector, \code{Date} variable}

\item{method}{\code{method} can be some of \verb{'BFGS','CG','Nelder-Mead', 'L-BFGS-B', 'nlm', 'nlminb', 'ucminf'}. \cr
For \code{I_optimx}, other methods are also supported,
e.g. \verb{'spg','Rcgmin','Rvmmin', 'newuoa','bobyqa','nmkb','hjkb'}.}

\item{...}{other parameters passed to \code{\link[=I_optim]{I_optim()}} or \code{\link[=I_optimx]{I_optimx()}}.}

\item{use.cpp}{(unstable, not used) boolean, whether to use c++ defined fine
fitting function? If \code{FALSE}, R version will be used.}

\item{verbose}{If \code{TRUE}, all optimization methods in
\code{\link[optimx:optimx]{optimx::optimx()}} are used, and print optimization information
of all methods.}
}
\value{
\itemize{
\item \code{convcode}: An integer code. 0 indicates successful convergence.
Various methods may or may not return sufficient information to allow all
the codes to be specified. An incomplete list of codes includes
\itemize{
\item \code{1}: indicates that the iteration limit \code{maxit} had been reached.
\item \code{20}: indicates that the initial set of parameters is inadmissible,
that is, that the function cannot be computed or returns an infinite,
NULL, or NA value.
\item \code{21}: indicates that an intermediate set of parameters is inadmissible.
\item \code{10}: indicates degeneracy of the Nelder--Mead simplex.
\item \code{51}: indicates a warning from the \code{"L-BFGS-B"} method; see component
\code{message} for further details.
\item \code{52}: indicates an error from the \code{"L-BFGS-B"} method; see component
\code{message} for further details.
\item \code{9999}: error
}
\item \code{value}: The value of fn corresponding to par
\item \code{par}: The best parameter found
\item \code{nitns}: the number of iterations
\item \code{fevals}: The number of calls to \code{objective}.
}
}
\description{
\pkg{optimx} speed is not satisfied. So \code{I_optim} is present.
\itemize{
\item \code{I_optim}: Interface of unified optimization functions.
\item \code{I_optimx}: deprecated, which is about 10 times slower than \code{I_optim}.
}
}
\examples{
# simulate vegetation time-series
FUN  = doubleLog_Beck
par  = c( mn  = 0.1 , mx  = 0.7 , sos = 50 , rsp = 0.1 , eos = 250, rau = 0.1)
par0 = c( mn  = 0.15, mx  = 0.65, sos = 100, rsp = 0.12, eos = 200, rau = 0.12)

t <- seq(1, 365, 8)
y <- FUN(par, t)

methods = c("BFGS", "ucminf", "nlm", "nlminb")
opt1 <- I_optim (par0, FUN, y, t, methods)
opt2 <- I_optimx(par0, FUN, y, t, methods)

# \dontrun{
# microbenchmark::microbenchmark(
#     opt1 = I_optim (par0, FUN, y, t, methods),
#     opt2 = I_optimx(par0, FUN, y, t, methods),
#     times = 2
# )
# }
}
\seealso{
\code{\link[stats:optim]{stats::optim()}}, \code{\link[stats:nlminb]{stats::nlminb()}},
\code{\link[stats:nlm]{stats::nlm()}}, \code{\link[optimx:optimx]{optimx::optimx()}},
\code{\link[ucminf:ucminf]{ucminf::ucminf()}}
}
\keyword{internal}
