% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/smooth_wWHIT.R
\name{smooth_wWHIT}
\alias{smooth_wWHIT}
\title{Weigthed Whittaker Smoother}
\usage{
smooth_wWHIT(
  y,
  w,
  ylu,
  nptperyear,
  wFUN = wTSM,
  iters = 1,
  lambda = 15,
  second = FALSE,
  ...
)
}
\arguments{
\item{y}{Numeric vector, vegetation index time-series}

\item{w}{(optional) Numeric vector, weights of \code{y}. If not specified,
weights of all \code{NA} values will be \code{wmin}, the others will be 1.0.}

\item{ylu}{\verb{[low, high]} of time-series y (curve fitting values are constrained
in the range of \code{ylu}.}

\item{nptperyear}{Integer, number of images per year.}

\item{wFUN}{weights updating function, can be one of 'wTSM', 'wChen' and
'wBisquare'.}

\item{iters}{How many times curve fitting is implemented.}

\item{lambda}{whittaker parameter (2-15 is suitable for 16-day VI). Multiple
lambda values also are accept, then a list object return.}

\item{second}{If true, in every iteration, Whittaker will be implemented
twice to make sure curve fitting is smooth. If curve has been smoothed
enough, it will not care about the second smooth. If no, the second one is
just prepared for this situation. If lambda value has been optimized, second
smoothing is unnecessary.}

\item{...}{Additional parameters are passed to \code{wFUN}.}
}
\value{
\itemize{
\item \code{ws}: weights of every iteration
\item \code{zs}: curve fittings of every iteration
}
}
\description{
Weigthed Whittaker Smoother
}
\examples{
library(phenofit)
data("MOD13A1")
dt <- tidy_MOD13.gee(MOD13A1$dt)
d <- dt[site == "AT-Neu", ]

l <- check_input(d$t, d$y, d$w, nptperyear=23)
r_wWHIT <- smooth_wWHIT(l$y, l$w, l$ylu, nptperyear = 23, iters = 2)
}
\references{
\enumerate{
\item Eilers, P.H.C., 2003. A perfect smoother. Anal. Chem. https://doi.org/10.1021/ac034173t \cr
\item Frasso, G., Eilers, P.H.C., 2015. L- and V-curves for optimal smoothing. Stat.
Modelling 15, 91–111. https://doi.org/10.1177/1471082X14549288
}
}
