% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tidy_MODIS.R
\name{getRealDate}
\alias{getRealDate}
\title{getRealDate}
\usage{
getRealDate(date, DayOfYear)
}
\arguments{
\item{date}{Date vector, the first day of the 16-day composite period.}

\item{DayOfYear}{Numeric vector, exact composite day of year.}
}
\value{
A data.table with a new column \code{t}, which is the exact compositing date.
}
\description{
convert MODIS \code{DayOfYear} to the exact compositing date.
}
\examples{
library(phenofit)
data("MOD13A1")

df  <- MOD13A1$dt
df$t <- getRealDate(df$date, df$DayOfYear)
}
