% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{run_structsearch}
\alias{run_structsearch}
\title{run_structsearch}
\usage{
run_structsearch(
  type,
  model,
  results,
  search_space = NULL,
  b_init = NULL,
  emax_init = NULL,
  ec50_init = NULL,
  met_init = NULL,
  extra_model = NULL,
  strictness = "minimization_successful or (rounding_errors and sigdigs >= 0.1)",
  extra_model_results = NULL,
  dv_types = NULL,
  ...
)
}
\arguments{
\item{type}{(str) Type of model. Currently only 'drug_metabolite' and 'pkpd'}

\item{model}{(Model) Search space to test}

\item{results}{(ModelfitResults) Initial estimate for the baseline for pkpd models.}

\item{search_space}{(str or ModelFeatures (optional)) Initial estimate for E_MAX (for pkpd models only).}

\item{b_init}{(numeric (optional)) Initial estimate for EC_50 (for pkpd models only).}

\item{emax_init}{(numeric (optional)) Initial estimate for MET (for pkpd models only).}

\item{ec50_init}{(numeric (optional)) Results for the start model}

\item{met_init}{(numeric (optional)) Pharmpy start model}

\item{extra_model}{(Model (optional)) Optional extra Pharmpy model to use in TMDD structsearch}

\item{strictness}{(str (optional)) Results for the extra model}

\item{extra_model_results}{(ModelfitResults (optional)) Strictness criteria}

\item{dv_types}{(list(str=numeric) (optional)) Dictionary of DV types for TMDD models with multiple DV}

\item{...}{Arguments to pass to tool}
}
\value{
(StructSearchResult) structsearch tool result object
}
\description{
Run the structsearch tool. For more details, see :ref:\code{structsearch}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
results <- load_example_modelfit_results("pheno")
run_structsearch(model_type='pkpd', results=results, model=model)
}

}
