% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{remove_covariate_effect}
\alias{remove_covariate_effect}
\title{remove_covariate_effect}
\usage{
remove_covariate_effect(model, parameter, covariate)
}
\arguments{
\item{model}{(Model) Pharmpy model from which to remove the covariate effect.}

\item{parameter}{(str) Name of parameter.}

\item{covariate}{(str) Name of covariate.}
}
\value{
(Model) Pharmpy model object
}
\description{
Remove a covariate effect from an instance of :class:\code{pharmpy.model}.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
has_covariate_effect(model, "CL", "WGT")
model <- remove_covariate_effect(model, "CL", "WGT")
has_covariate_effect(model, "CL", "WGT")
}

}
