% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{evaluate_weighted_residuals}
\alias{evaluate_weighted_residuals}
\title{evaluate_weighted_residuals}
\usage{
evaluate_weighted_residuals(model, parameters = NULL, dataset = NULL)
}
\arguments{
\item{model}{(Model) Pharmpy model}

\item{parameters}{(list(str=numeric) (optional)) Optional list of parameters and values}

\item{dataset}{(data.frame (optional)) Optional dataset}
}
\value{
(data.frame) WRES
}
\description{
Evaluate the weighted residuals

The residuals is evaluated at the current model parameter values
or optionally at the given parameter values.
The residuals is done for each data record in the model dataset
or optionally using the dataset argument.

This function currently only support models without ODE systems
}
\examples{
\dontrun{
model <- load_example_model("pheno_linear")
results <- load_example_modelfit_results("pheno_linear")
parameters <- results$parameter_estimates
evaluate_weighted_residuals(model, parameters=list(parameters))
}

}
