% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_wrapper.R
\name{set_power_on_ruv}
\alias{set_power_on_ruv}
\title{set_power_on_ruv}
\usage{
set_power_on_ruv(
  model,
  list_of_eps = NULL,
  lower_limit = 0.01,
  ipred = NULL,
  zero_protection = FALSE
)
}
\arguments{
\item{model}{(Model) Pharmpy model to create block effect on.}

\item{list_of_eps}{(str, vector) Name/names of epsilons to apply power effect. If NULL, all epsilons will be used.
NULL is default.}

\item{lower_limit}{(integer or NULL) Lower limit of power (theta). NULL for no limit.}

\item{ipred}{(Symbol) Symbol to use as IPRED. Default is to autodetect expression for IPRED.}

\item{zero_protection}{(logical) Set to TRUE to add code protecting from IPRED=0}
}
\value{
(Model) Reference to the same model
}
\description{
Applies a power effect to provided epsilons.

Initial estimates for new thetas are 1 if the error
model is proportional, otherwise they are 0.1.
}
\examples{
\dontrun{
model <- load_example_model("pheno")
set_power_on_ruv(model)
model$statements$find_assignment("Y")
}
}
\seealso{
set_iiv_on_ruv
}
