/*
 * Decompiled with CFR 0.152.
 */
package net.sf.eps2pgf.ps.resources;

import java.util.HashMap;
import java.util.Map;
import net.sf.eps2pgf.ps.objects.PSObjectName;

public final class Encoding {
    private static boolean alreadyInitialized = false;
    private static Map<String, PSObjectName> names;
    private static PSObjectName[] standard;
    private static PSObjectName[] isoLatin1;
    private static PSObjectName[] symbol;

    private Encoding() {
    }

    public static void initialize() {
        if (alreadyInitialized) {
            return;
        }
        Encoding.initNames();
        Encoding.initStandardEncoding();
        Encoding.initISOLatin1Encoding();
        Encoding.initSymbolEncoding();
        alreadyInitialized = true;
    }

    public static PSObjectName[] getStandardVector() {
        return (PSObjectName[])standard.clone();
    }

    public static PSObjectName[] getISOLatin1Vector() {
        return (PSObjectName[])isoLatin1.clone();
    }

    public static PSObjectName[] getSymbolVector() {
        return (PSObjectName[])symbol.clone();
    }

    private static void initNames() {
        String[] stringArray = new String[]{".notdef", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z", "a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "AE", "CR", "Mu", "Nu", "OE", "Pi", "Xi", "ae", "at", "ff", "fi", "fl", "mu", "nu", "oe", "pi", "xi", "Chi", "Eta", "Eth", "Ohm", "Phi", "Psi", "Rho", "Tau", "bar", "chi", "eta", "eth", "ffi", "ffl", "mu1", "one", "phi", "psi", "rho", "six", "tau", "two", "yen", "Beta", "Euro", "Iota", "Zeta", "beta", "cent", "club", "five", "four", "iota", "less", "nine", "phi1", "plus", "ring", "zero", "zeta", "Alpha", "Aring", "Delta", "Gamma", "Kappa", "Omega", "Sigma", "Theta", "Thorn", "Uring", "acute", "aleph", "alpha", "angle", "aring", "breve", "caron", "colon", "comma", "delta", "eight", "equal", "franc", "gamma", "grave", "heart", "kappa", "minus", "omega", "seven", "sigma", "slash", "space", "spade", "theta", "thorn", "three", "tilde", "union", "uring", "Aacute", "Abreve", "Agrave", "Asmall", "Atilde", "Bsmall", "Cacute", "Ccaron", "Csmall", "Dcaron", "Dcroat", "Dsmall", "Eacute", "Ecaron", "Egrave", "Esmall", "Fsmall", "Gbreve", "Gsmall", "Hsmall", "Iacute", "Igrave", "Ismall", "Jsmall", "Ksmall", "Lacute", "Lambda", "Lcaron", "Lslash", "Lsmall", "Msmall", "Nacute", "Ncaron", "Nsmall", "Ntilde", "Oacute", "Ograve", "Oslash", "Osmall", "Otilde", "Psmall", "Qsmall", "Racute", "Rcaron", "Rsmall", "Sacute", "Scaron", "Ssmall", "Tcaron", "Tsmall", "Uacute", "Ugrave", "Usmall", "Vsmall", "Wsmall", "Xsmall", "Yacute", "Ysmall", "Zacute", "Zcaron", "Zsmall", "aacute", "abreve", "agrave", "atilde", "bullet", "cacute", "ccaron", "dagger", "dcaron", "dcroat", "degree", "divide", "dollar", "eacute", "ecaron", "egrave", "emdash", "endash", "exclam", "florin", "gbreve", "hyphen", "iacute", "igrave", "lacute", "lambda", "lcaron", "lslash", "macron", "minute", "nacute", "ncaron", "ntilde", "oacute", "ogonek", "ograve", "omega1", "oslash", "otilde", "period", "racute", "rcaron", "rupiah", "sacute", "scaron", "second", "sigma1", "tcaron", "theta1", "uacute", "ugrave", "yacute", "zacute", "zcaron", "AEsmall", "Amacron", "Aogonek", "Emacron", "Eogonek", "Epsilon", "Imacron", "Iogonek", "OEsmall", "Omacron", "Omicron", "Umacron", "Uogonek", "Upsilon", "amacron", "aogonek", "arrowup", "braceex", "cedilla", "diamond", "dmacron", "dotmath", "element", "emacron", "eogonek", "epsilon", "greater", "imacron", "iogonek", "lozenge", "nbspace", "omacron", "omicron", "onehalf", "percent", "product", "radical", "section", "similar", "umacron", "uogonek", "upsilon", "Ccedilla", "Ethsmall", "Ifraktur", "Rfraktur", "Scedilla", "Upsilon1", "asterisk", "ccedilla", "currency", "dieresis", "dotlessi", "ellipsis", "emptyset", "fraction", "gradient", "infinity", "integral", "multiply", "notequal", "onethird", "question", "quotedbl", "scedilla", "sterling", "suchthat", "Adieresis", "Edieresis", "Idieresis", "Odieresis", "Ringsmall", "Udieresis", "Ydieresis", "adieresis", "ampersand", "angleleft", "applelogo", "arrowboth", "arrowdown", "arrowleft", "asuperior", "backslash", "braceleft", "brokenbar", "bsuperior", "congruent", "copyright", "daggerdbl", "dotaccent", "dsuperior", "edieresis", "esuperior", "idieresis", "increment", "isuperior", "lessequal", "logicalor", "lsuperior", "msuperior", "notsubset", "nsuperior", "odieresis", "oneeighth", "onefitted", "osuperior", "overscore", "paragraph", "parenleft", "plusminus", "quoteleft", "radicalex", "rsuperior", "semicolon", "ssuperior", "summation", "therefore", "trademark", "tsuperior", "twothirds", "udieresis", "universal", "ydieresis", "Acutesmall", "Aringsmall", "Brevesmall", "Caronsmall", "Edotaccent", "Gravesmall", "Idotaccent", "Thornsmall", "Tildesmall", "Zdotaccent", "angleright", "arrowdblup", "arrowright", "asciitilde", "braceright", "circleplus", "circumflex", "edotaccent", "exclamdown", "figuredash", "germandbls", "integralbt", "integralex", "integraltp", "logicaland", "logicalnot", "notelement", "numbersign", "onequarter", "parenright", "quoteright", "registered", "underscore", "zdotaccent", "Aacutesmall", "Acircumflex", "Agravesmall", "Atildesmall", "Eacutesmall", "Ecircumflex", "Egravesmall", "Iacutesmall", "Icircumflex", "Igravesmall", "Lslashsmall", "Macronsmall", "Ntildesmall", "Oacutesmall", "Ocircumflex", "Ogoneksmall", "Ogravesmall", "Oslashsmall", "Otildesmall", "Scaronsmall", "Uacutesmall", "Ucircumflex", "Ugravesmall", "Yacutesmall", "Zcaronsmall", "acircumflex", "approxequal", "arrowvertex", "asciicircum", "braceleftbt", "bracelefttp", "bracketleft", "commaaccent", "ecircumflex", "equivalence", "exclamsmall", "existential", "fiveeighths", "icircumflex", "ocircumflex", "oneinferior", "oneoldstyle", "onesuperior", "ordfeminine", "parenleftbt", "parenleftex", "parenlefttp", "partialdiff", "perthousand", "quotesingle", "sixinferior", "sixoldstyle", "sixsuperior", "twoinferior", "twooldstyle", "twosuperior", "ucircumflex", "weierstrass", "Cedillasmall", "Gcommaaccent", "Kcommaaccent", "Lcommaaccent", "Ncommaaccent", "Rcommaaccent", "Scommaaccent", "Tcommaaccent", "arrowdblboth", "arrowdbldown", "arrowdblleft", "arrowhorizex", "asteriskmath", "braceleftmid", "bracerightbt", "bracerighttp", "bracketright", "centinferior", "centoldstyle", "centsuperior", "fiveinferior", "fiveoldstyle", "fivesuperior", "fourinferior", "fouroldstyle", "foursuperior", "gcommaaccent", "greaterequal", "hungarumlaut", "intersection", "kcommaaccent", "lcommaaccent", "ncommaaccent", "nineinferior", "nineoldstyle", "ninesuperior", "ordmasculine", "parenrightbt", "parenrightex", "parenrighttp", "propersubset", "proportional", "questiondown", "quotedblbase", "quotedblleft", "rcommaaccent", "reflexsubset", "registersans", "scommaaccent", "seveneighths", "tcommaaccent", "threeeighths", "zeroinferior", "zerooldstyle", "zerosuperior", "Ccedillasmall", "Dieresissmall", "Ohungarumlaut", "Uhungarumlaut", "arrowdblright", "bracerightmid", "bracketleftbt", "bracketleftex", "bracketlefttp", "colonmonetary", "commainferior", "commasuperior", "copyrightsans", "eightinferior", "eightoldstyle", "eightsuperior", "guillemotleft", "guilsinglleft", "ohungarumlaut", "perpendicular", "questionsmall", "quotedblright", "registerserif", "seveninferior", "sevenoldstyle", "sevensuperior", "threeinferior", "threeoldstyle", "threequarters", "threesuperior", "trademarksans", "uhungarumlaut", "Adieresissmall", "Dotaccentsmall", "Edieresissmall", "Idieresissmall", "Odieresissmall", "Udieresissmall", "Ydieresissmall", "ampersandsmall", "bracketrightbt", "bracketrightex", "bracketrighttp", "carriagereturn", "circlemultiply", "copyrightserif", "dollarinferior", "dollaroldstyle", "dollarsuperior", "guillemotright", "guilsinglright", "hypheninferior", "hyphensuperior", "onedotenleader", "periodcentered", "periodinferior", "periodsuperior", "propersuperset", "quotesinglbase", "reflexsuperset", "trademarkserif", "twodotenleader", "Circumflexsmall", "exclamdownsmall", "Acircumflexsmall", "Ecircumflexsmall", "Icircumflexsmall", "Ocircumflexsmall", "Ucircumflexsmall", "Hungarumlautsmall", "parenleftinferior", "parenleftsuperior", "questiondownsmall", "parenrightinferior", "parenrightsuperior", "threequartersemdash"};
        names = new HashMap<String, PSObjectName>(stringArray.length);
        for (int i = 0; i < stringArray.length; ++i) {
            names.put(stringArray[i], new PSObjectName("/" + stringArray[i]));
        }
    }

    private static void initStandardEncoding() {
        Encoding.standard[0] = names.get(".notdef");
        Encoding.standard[1] = names.get(".notdef");
        Encoding.standard[2] = names.get(".notdef");
        Encoding.standard[3] = names.get(".notdef");
        Encoding.standard[4] = names.get(".notdef");
        Encoding.standard[5] = names.get(".notdef");
        Encoding.standard[6] = names.get(".notdef");
        Encoding.standard[7] = names.get(".notdef");
        Encoding.standard[8] = names.get(".notdef");
        Encoding.standard[9] = names.get(".notdef");
        Encoding.standard[10] = names.get(".notdef");
        Encoding.standard[11] = names.get(".notdef");
        Encoding.standard[12] = names.get(".notdef");
        Encoding.standard[13] = names.get(".notdef");
        Encoding.standard[14] = names.get(".notdef");
        Encoding.standard[15] = names.get(".notdef");
        Encoding.standard[16] = names.get(".notdef");
        Encoding.standard[17] = names.get(".notdef");
        Encoding.standard[18] = names.get(".notdef");
        Encoding.standard[19] = names.get(".notdef");
        Encoding.standard[20] = names.get(".notdef");
        Encoding.standard[21] = names.get(".notdef");
        Encoding.standard[22] = names.get(".notdef");
        Encoding.standard[23] = names.get(".notdef");
        Encoding.standard[24] = names.get(".notdef");
        Encoding.standard[25] = names.get(".notdef");
        Encoding.standard[26] = names.get(".notdef");
        Encoding.standard[27] = names.get(".notdef");
        Encoding.standard[28] = names.get(".notdef");
        Encoding.standard[29] = names.get(".notdef");
        Encoding.standard[30] = names.get(".notdef");
        Encoding.standard[31] = names.get(".notdef");
        Encoding.standard[32] = names.get("space");
        Encoding.standard[33] = names.get("exclam");
        Encoding.standard[34] = names.get("quotedbl");
        Encoding.standard[35] = names.get("numbersign");
        Encoding.standard[36] = names.get("dollar");
        Encoding.standard[37] = names.get("percent");
        Encoding.standard[38] = names.get("ampersand");
        Encoding.standard[39] = names.get("quoteright");
        Encoding.standard[40] = names.get("parenleft");
        Encoding.standard[41] = names.get("parenright");
        Encoding.standard[42] = names.get("asterisk");
        Encoding.standard[43] = names.get("plus");
        Encoding.standard[44] = names.get("comma");
        Encoding.standard[45] = names.get("minus");
        Encoding.standard[46] = names.get("period");
        Encoding.standard[47] = names.get("slash");
        Encoding.standard[48] = names.get("zero");
        Encoding.standard[49] = names.get("one");
        Encoding.standard[50] = names.get("two");
        Encoding.standard[51] = names.get("three");
        Encoding.standard[52] = names.get("four");
        Encoding.standard[53] = names.get("five");
        Encoding.standard[54] = names.get("six");
        Encoding.standard[55] = names.get("seven");
        Encoding.standard[56] = names.get("eight");
        Encoding.standard[57] = names.get("nine");
        Encoding.standard[58] = names.get("colon");
        Encoding.standard[59] = names.get("semicolon");
        Encoding.standard[60] = names.get("less");
        Encoding.standard[61] = names.get("equal");
        Encoding.standard[62] = names.get("greater");
        Encoding.standard[63] = names.get("question");
        Encoding.standard[64] = names.get("at");
        Encoding.standard[65] = names.get("A");
        Encoding.standard[66] = names.get("B");
        Encoding.standard[67] = names.get("C");
        Encoding.standard[68] = names.get("D");
        Encoding.standard[69] = names.get("E");
        Encoding.standard[70] = names.get("F");
        Encoding.standard[71] = names.get("G");
        Encoding.standard[72] = names.get("H");
        Encoding.standard[73] = names.get("I");
        Encoding.standard[74] = names.get("J");
        Encoding.standard[75] = names.get("K");
        Encoding.standard[76] = names.get("L");
        Encoding.standard[77] = names.get("M");
        Encoding.standard[78] = names.get("N");
        Encoding.standard[79] = names.get("O");
        Encoding.standard[80] = names.get("P");
        Encoding.standard[81] = names.get("Q");
        Encoding.standard[82] = names.get("R");
        Encoding.standard[83] = names.get("S");
        Encoding.standard[84] = names.get("T");
        Encoding.standard[85] = names.get("U");
        Encoding.standard[86] = names.get("V");
        Encoding.standard[87] = names.get("W");
        Encoding.standard[88] = names.get("X");
        Encoding.standard[89] = names.get("Y");
        Encoding.standard[90] = names.get("Z");
        Encoding.standard[91] = names.get("bracketleft");
        Encoding.standard[92] = names.get("backslash");
        Encoding.standard[93] = names.get("bracketright");
        Encoding.standard[94] = names.get("asciicircum");
        Encoding.standard[95] = names.get("underscore");
        Encoding.standard[96] = names.get("quoteleft");
        Encoding.standard[97] = names.get("a");
        Encoding.standard[98] = names.get("b");
        Encoding.standard[99] = names.get("c");
        Encoding.standard[100] = names.get("d");
        Encoding.standard[101] = names.get("e");
        Encoding.standard[102] = names.get("f");
        Encoding.standard[103] = names.get("g");
        Encoding.standard[104] = names.get("h");
        Encoding.standard[105] = names.get("i");
        Encoding.standard[106] = names.get("j");
        Encoding.standard[107] = names.get("k");
        Encoding.standard[108] = names.get("l");
        Encoding.standard[109] = names.get("m");
        Encoding.standard[110] = names.get("n");
        Encoding.standard[111] = names.get("o");
        Encoding.standard[112] = names.get("p");
        Encoding.standard[113] = names.get("q");
        Encoding.standard[114] = names.get("r");
        Encoding.standard[115] = names.get("s");
        Encoding.standard[116] = names.get("t");
        Encoding.standard[117] = names.get("u");
        Encoding.standard[118] = names.get("v");
        Encoding.standard[119] = names.get("w");
        Encoding.standard[120] = names.get("x");
        Encoding.standard[121] = names.get("y");
        Encoding.standard[122] = names.get("z");
        Encoding.standard[123] = names.get("braceleft");
        Encoding.standard[124] = names.get("bar");
        Encoding.standard[125] = names.get("braceright");
        Encoding.standard[126] = names.get("asciitilde");
        Encoding.standard[127] = names.get(".notdef");
        Encoding.standard[128] = names.get(".notdef");
        Encoding.standard[129] = names.get(".notdef");
        Encoding.standard[130] = names.get(".notdef");
        Encoding.standard[131] = names.get(".notdef");
        Encoding.standard[132] = names.get(".notdef");
        Encoding.standard[133] = names.get(".notdef");
        Encoding.standard[134] = names.get(".notdef");
        Encoding.standard[135] = names.get(".notdef");
        Encoding.standard[136] = names.get(".notdef");
        Encoding.standard[137] = names.get(".notdef");
        Encoding.standard[138] = names.get(".notdef");
        Encoding.standard[139] = names.get(".notdef");
        Encoding.standard[140] = names.get(".notdef");
        Encoding.standard[141] = names.get(".notdef");
        Encoding.standard[142] = names.get(".notdef");
        Encoding.standard[143] = names.get(".notdef");
        Encoding.standard[144] = names.get(".notdef");
        Encoding.standard[145] = names.get(".notdef");
        Encoding.standard[146] = names.get(".notdef");
        Encoding.standard[147] = names.get(".notdef");
        Encoding.standard[148] = names.get(".notdef");
        Encoding.standard[149] = names.get(".notdef");
        Encoding.standard[150] = names.get(".notdef");
        Encoding.standard[151] = names.get(".notdef");
        Encoding.standard[152] = names.get(".notdef");
        Encoding.standard[153] = names.get(".notdef");
        Encoding.standard[154] = names.get(".notdef");
        Encoding.standard[155] = names.get(".notdef");
        Encoding.standard[156] = names.get(".notdef");
        Encoding.standard[157] = names.get(".notdef");
        Encoding.standard[158] = names.get(".notdef");
        Encoding.standard[159] = names.get(".notdef");
        Encoding.standard[160] = names.get(".notdef");
        Encoding.standard[161] = names.get("exclamdown");
        Encoding.standard[162] = names.get("cent");
        Encoding.standard[163] = names.get("sterling");
        Encoding.standard[164] = names.get("fraction");
        Encoding.standard[165] = names.get("yen");
        Encoding.standard[166] = names.get("florin");
        Encoding.standard[167] = names.get("section");
        Encoding.standard[168] = names.get("currency");
        Encoding.standard[169] = names.get("quotesingle");
        Encoding.standard[170] = names.get("quotedblleft");
        Encoding.standard[171] = names.get("guillemotleft");
        Encoding.standard[172] = names.get("guilsinglleft");
        Encoding.standard[173] = names.get("guilsinglright");
        Encoding.standard[174] = names.get("fi");
        Encoding.standard[175] = names.get("fl");
        Encoding.standard[176] = names.get(".notdef");
        Encoding.standard[177] = names.get("endash");
        Encoding.standard[178] = names.get("dagger");
        Encoding.standard[179] = names.get("daggerdbl");
        Encoding.standard[180] = names.get("periodcentered");
        Encoding.standard[181] = names.get(".notdef");
        Encoding.standard[182] = names.get("paragraph");
        Encoding.standard[183] = names.get("bullet");
        Encoding.standard[184] = names.get("quotesinglbase");
        Encoding.standard[185] = names.get("quotedblbase");
        Encoding.standard[186] = names.get("quotedblright");
        Encoding.standard[187] = names.get("guillemotright");
        Encoding.standard[188] = names.get("ellipsis");
        Encoding.standard[189] = names.get("perthousand");
        Encoding.standard[190] = names.get(".notdef");
        Encoding.standard[191] = names.get("questiondown");
        Encoding.standard[192] = names.get(".notdef");
        Encoding.standard[193] = names.get("grave");
        Encoding.standard[194] = names.get("acute");
        Encoding.standard[195] = names.get("circumflex");
        Encoding.standard[196] = names.get("tilde");
        Encoding.standard[197] = names.get("macron");
        Encoding.standard[198] = names.get("breve");
        Encoding.standard[199] = names.get("dotaccent");
        Encoding.standard[200] = names.get("dieresis");
        Encoding.standard[201] = names.get(".notdef");
        Encoding.standard[202] = names.get("ring");
        Encoding.standard[203] = names.get("cedilla");
        Encoding.standard[204] = names.get(".notdef");
        Encoding.standard[205] = names.get("hungarumlaut");
        Encoding.standard[206] = names.get("ogonek");
        Encoding.standard[207] = names.get("caron");
        Encoding.standard[208] = names.get("emdash");
        Encoding.standard[209] = names.get(".notdef");
        Encoding.standard[210] = names.get(".notdef");
        Encoding.standard[211] = names.get(".notdef");
        Encoding.standard[212] = names.get(".notdef");
        Encoding.standard[213] = names.get(".notdef");
        Encoding.standard[214] = names.get(".notdef");
        Encoding.standard[215] = names.get(".notdef");
        Encoding.standard[216] = names.get(".notdef");
        Encoding.standard[217] = names.get(".notdef");
        Encoding.standard[218] = names.get(".notdef");
        Encoding.standard[219] = names.get(".notdef");
        Encoding.standard[220] = names.get(".notdef");
        Encoding.standard[221] = names.get(".notdef");
        Encoding.standard[222] = names.get(".notdef");
        Encoding.standard[223] = names.get(".notdef");
        Encoding.standard[224] = names.get(".notdef");
        Encoding.standard[225] = names.get("AE");
        Encoding.standard[226] = names.get(".notdef");
        Encoding.standard[227] = names.get("ordfeminine");
        Encoding.standard[228] = names.get(".notdef");
        Encoding.standard[229] = names.get(".notdef");
        Encoding.standard[230] = names.get(".notdef");
        Encoding.standard[231] = names.get(".notdef");
        Encoding.standard[232] = names.get("Lslash");
        Encoding.standard[233] = names.get("Oslash");
        Encoding.standard[234] = names.get("OE");
        Encoding.standard[235] = names.get("ordmasculine");
        Encoding.standard[236] = names.get(".notdef");
        Encoding.standard[237] = names.get(".notdef");
        Encoding.standard[238] = names.get(".notdef");
        Encoding.standard[239] = names.get(".notdef");
        Encoding.standard[240] = names.get(".notdef");
        Encoding.standard[241] = names.get("ae");
        Encoding.standard[242] = names.get(".notdef");
        Encoding.standard[243] = names.get(".notdef");
        Encoding.standard[244] = names.get(".notdef");
        Encoding.standard[245] = names.get("dotlessi");
        Encoding.standard[246] = names.get(".notdef");
        Encoding.standard[247] = names.get(".notdef");
        Encoding.standard[248] = names.get("lslash");
        Encoding.standard[249] = names.get("oslash");
        Encoding.standard[250] = names.get("oe");
        Encoding.standard[251] = names.get("germandbls");
        Encoding.standard[252] = names.get(".notdef");
        Encoding.standard[253] = names.get(".notdef");
        Encoding.standard[254] = names.get(".notdef");
        Encoding.standard[255] = names.get(".notdef");
    }

    private static void initISOLatin1Encoding() {
        Encoding.isoLatin1[0] = names.get(".notdef");
        Encoding.isoLatin1[1] = names.get(".notdef");
        Encoding.isoLatin1[2] = names.get(".notdef");
        Encoding.isoLatin1[3] = names.get(".notdef");
        Encoding.isoLatin1[4] = names.get(".notdef");
        Encoding.isoLatin1[5] = names.get(".notdef");
        Encoding.isoLatin1[6] = names.get(".notdef");
        Encoding.isoLatin1[7] = names.get(".notdef");
        Encoding.isoLatin1[8] = names.get(".notdef");
        Encoding.isoLatin1[9] = names.get(".notdef");
        Encoding.isoLatin1[10] = names.get(".notdef");
        Encoding.isoLatin1[11] = names.get(".notdef");
        Encoding.isoLatin1[12] = names.get(".notdef");
        Encoding.isoLatin1[13] = names.get(".notdef");
        Encoding.isoLatin1[14] = names.get(".notdef");
        Encoding.isoLatin1[15] = names.get(".notdef");
        Encoding.isoLatin1[16] = names.get(".notdef");
        Encoding.isoLatin1[17] = names.get(".notdef");
        Encoding.isoLatin1[18] = names.get(".notdef");
        Encoding.isoLatin1[19] = names.get(".notdef");
        Encoding.isoLatin1[20] = names.get(".notdef");
        Encoding.isoLatin1[21] = names.get(".notdef");
        Encoding.isoLatin1[22] = names.get(".notdef");
        Encoding.isoLatin1[23] = names.get(".notdef");
        Encoding.isoLatin1[24] = names.get(".notdef");
        Encoding.isoLatin1[25] = names.get(".notdef");
        Encoding.isoLatin1[26] = names.get(".notdef");
        Encoding.isoLatin1[27] = names.get(".notdef");
        Encoding.isoLatin1[28] = names.get(".notdef");
        Encoding.isoLatin1[29] = names.get(".notdef");
        Encoding.isoLatin1[30] = names.get(".notdef");
        Encoding.isoLatin1[31] = names.get(".notdef");
        Encoding.isoLatin1[32] = names.get("space");
        Encoding.isoLatin1[33] = names.get("exclam");
        Encoding.isoLatin1[34] = names.get("quotedbl");
        Encoding.isoLatin1[35] = names.get("numbersign");
        Encoding.isoLatin1[36] = names.get("dollar");
        Encoding.isoLatin1[37] = names.get("percent");
        Encoding.isoLatin1[38] = names.get("ampersand");
        Encoding.isoLatin1[39] = names.get("quoteright");
        Encoding.isoLatin1[40] = names.get("parenleft");
        Encoding.isoLatin1[41] = names.get("parenright");
        Encoding.isoLatin1[42] = names.get("asterisk");
        Encoding.isoLatin1[43] = names.get("plus");
        Encoding.isoLatin1[44] = names.get("comma");
        Encoding.isoLatin1[45] = names.get("minus");
        Encoding.isoLatin1[46] = names.get("period");
        Encoding.isoLatin1[47] = names.get("slash");
        Encoding.isoLatin1[48] = names.get("zero");
        Encoding.isoLatin1[49] = names.get("one");
        Encoding.isoLatin1[50] = names.get("two");
        Encoding.isoLatin1[51] = names.get("three");
        Encoding.isoLatin1[52] = names.get("four");
        Encoding.isoLatin1[53] = names.get("five");
        Encoding.isoLatin1[54] = names.get("six");
        Encoding.isoLatin1[55] = names.get("seven");
        Encoding.isoLatin1[56] = names.get("eight");
        Encoding.isoLatin1[57] = names.get("nine");
        Encoding.isoLatin1[58] = names.get("colon");
        Encoding.isoLatin1[59] = names.get("semicolon");
        Encoding.isoLatin1[60] = names.get("less");
        Encoding.isoLatin1[61] = names.get("equal");
        Encoding.isoLatin1[62] = names.get("greater");
        Encoding.isoLatin1[63] = names.get("question");
        Encoding.isoLatin1[64] = names.get("at");
        Encoding.isoLatin1[65] = names.get("A");
        Encoding.isoLatin1[66] = names.get("B");
        Encoding.isoLatin1[67] = names.get("C");
        Encoding.isoLatin1[68] = names.get("D");
        Encoding.isoLatin1[69] = names.get("E");
        Encoding.isoLatin1[70] = names.get("F");
        Encoding.isoLatin1[71] = names.get("G");
        Encoding.isoLatin1[72] = names.get("H");
        Encoding.isoLatin1[73] = names.get("I");
        Encoding.isoLatin1[74] = names.get("J");
        Encoding.isoLatin1[75] = names.get("K");
        Encoding.isoLatin1[76] = names.get("L");
        Encoding.isoLatin1[77] = names.get("M");
        Encoding.isoLatin1[78] = names.get("N");
        Encoding.isoLatin1[79] = names.get("O");
        Encoding.isoLatin1[80] = names.get("P");
        Encoding.isoLatin1[81] = names.get("Q");
        Encoding.isoLatin1[82] = names.get("R");
        Encoding.isoLatin1[83] = names.get("S");
        Encoding.isoLatin1[84] = names.get("T");
        Encoding.isoLatin1[85] = names.get("U");
        Encoding.isoLatin1[86] = names.get("V");
        Encoding.isoLatin1[87] = names.get("W");
        Encoding.isoLatin1[88] = names.get("X");
        Encoding.isoLatin1[89] = names.get("Y");
        Encoding.isoLatin1[90] = names.get("Z");
        Encoding.isoLatin1[91] = names.get("bracketleft");
        Encoding.isoLatin1[92] = names.get("backslash");
        Encoding.isoLatin1[93] = names.get("bracketright");
        Encoding.isoLatin1[94] = names.get("asciicircum");
        Encoding.isoLatin1[95] = names.get("underscore");
        Encoding.isoLatin1[96] = names.get("quoteleft");
        Encoding.isoLatin1[97] = names.get("a");
        Encoding.isoLatin1[98] = names.get("b");
        Encoding.isoLatin1[99] = names.get("c");
        Encoding.isoLatin1[100] = names.get("d");
        Encoding.isoLatin1[101] = names.get("e");
        Encoding.isoLatin1[102] = names.get("f");
        Encoding.isoLatin1[103] = names.get("g");
        Encoding.isoLatin1[104] = names.get("h");
        Encoding.isoLatin1[105] = names.get("i");
        Encoding.isoLatin1[106] = names.get("j");
        Encoding.isoLatin1[107] = names.get("k");
        Encoding.isoLatin1[108] = names.get("l");
        Encoding.isoLatin1[109] = names.get("m");
        Encoding.isoLatin1[110] = names.get("n");
        Encoding.isoLatin1[111] = names.get("o");
        Encoding.isoLatin1[112] = names.get("p");
        Encoding.isoLatin1[113] = names.get("q");
        Encoding.isoLatin1[114] = names.get("r");
        Encoding.isoLatin1[115] = names.get("s");
        Encoding.isoLatin1[116] = names.get("t");
        Encoding.isoLatin1[117] = names.get("u");
        Encoding.isoLatin1[118] = names.get("v");
        Encoding.isoLatin1[119] = names.get("w");
        Encoding.isoLatin1[120] = names.get("x");
        Encoding.isoLatin1[121] = names.get("y");
        Encoding.isoLatin1[122] = names.get("z");
        Encoding.isoLatin1[123] = names.get("braceleft");
        Encoding.isoLatin1[124] = names.get("bar");
        Encoding.isoLatin1[125] = names.get("braceright");
        Encoding.isoLatin1[126] = names.get("asciitilde");
        Encoding.isoLatin1[127] = names.get(".notdef");
        Encoding.isoLatin1[128] = names.get(".notdef");
        Encoding.isoLatin1[129] = names.get(".notdef");
        Encoding.isoLatin1[130] = names.get(".notdef");
        Encoding.isoLatin1[131] = names.get(".notdef");
        Encoding.isoLatin1[132] = names.get(".notdef");
        Encoding.isoLatin1[133] = names.get(".notdef");
        Encoding.isoLatin1[134] = names.get(".notdef");
        Encoding.isoLatin1[135] = names.get(".notdef");
        Encoding.isoLatin1[136] = names.get(".notdef");
        Encoding.isoLatin1[137] = names.get(".notdef");
        Encoding.isoLatin1[138] = names.get(".notdef");
        Encoding.isoLatin1[139] = names.get(".notdef");
        Encoding.isoLatin1[140] = names.get(".notdef");
        Encoding.isoLatin1[141] = names.get(".notdef");
        Encoding.isoLatin1[142] = names.get(".notdef");
        Encoding.isoLatin1[143] = names.get(".notdef");
        Encoding.isoLatin1[144] = names.get("dotlessi");
        Encoding.isoLatin1[145] = names.get("grave");
        Encoding.isoLatin1[146] = names.get("acute");
        Encoding.isoLatin1[147] = names.get("circumflex");
        Encoding.isoLatin1[148] = names.get("tilde");
        Encoding.isoLatin1[149] = names.get("macron");
        Encoding.isoLatin1[150] = names.get("breve");
        Encoding.isoLatin1[151] = names.get("dotaccent");
        Encoding.isoLatin1[152] = names.get("dieresis");
        Encoding.isoLatin1[153] = names.get(".notdef");
        Encoding.isoLatin1[154] = names.get("ring");
        Encoding.isoLatin1[155] = names.get("cedilla");
        Encoding.isoLatin1[156] = names.get(".notdef");
        Encoding.isoLatin1[157] = names.get("hungarumlaut");
        Encoding.isoLatin1[158] = names.get("ogonek");
        Encoding.isoLatin1[159] = names.get("caron");
        Encoding.isoLatin1[160] = names.get("space");
        Encoding.isoLatin1[161] = names.get("exclamdown");
        Encoding.isoLatin1[162] = names.get("cent");
        Encoding.isoLatin1[163] = names.get("sterling");
        Encoding.isoLatin1[164] = names.get("currency");
        Encoding.isoLatin1[165] = names.get("yen");
        Encoding.isoLatin1[166] = names.get("brokenbar");
        Encoding.isoLatin1[167] = names.get("section");
        Encoding.isoLatin1[168] = names.get("dieresis");
        Encoding.isoLatin1[169] = names.get("copyright");
        Encoding.isoLatin1[170] = names.get("ordfeminine");
        Encoding.isoLatin1[171] = names.get("guillemotleft");
        Encoding.isoLatin1[172] = names.get("logicalnot");
        Encoding.isoLatin1[173] = names.get("hyphen");
        Encoding.isoLatin1[174] = names.get("registered");
        Encoding.isoLatin1[175] = names.get("macron");
        Encoding.isoLatin1[176] = names.get("degree");
        Encoding.isoLatin1[177] = names.get("plusminus");
        Encoding.isoLatin1[178] = names.get("twosuperior");
        Encoding.isoLatin1[179] = names.get("threesuperior");
        Encoding.isoLatin1[180] = names.get("acute");
        Encoding.isoLatin1[181] = names.get("mu");
        Encoding.isoLatin1[182] = names.get("paragraph");
        Encoding.isoLatin1[183] = names.get("periodcentered");
        Encoding.isoLatin1[184] = names.get("cedilla");
        Encoding.isoLatin1[185] = names.get("onesuperior");
        Encoding.isoLatin1[186] = names.get("ordmasculine");
        Encoding.isoLatin1[187] = names.get("guillemotright");
        Encoding.isoLatin1[188] = names.get("onequarter");
        Encoding.isoLatin1[189] = names.get("onehalf");
        Encoding.isoLatin1[190] = names.get("threequarters");
        Encoding.isoLatin1[191] = names.get("questiondown");
        Encoding.isoLatin1[192] = names.get("Agrave");
        Encoding.isoLatin1[193] = names.get("Aacute");
        Encoding.isoLatin1[194] = names.get("Acircumflex");
        Encoding.isoLatin1[195] = names.get("Atilde");
        Encoding.isoLatin1[196] = names.get("Adieresis");
        Encoding.isoLatin1[197] = names.get("Aring");
        Encoding.isoLatin1[198] = names.get("AE");
        Encoding.isoLatin1[199] = names.get("Ccedilla");
        Encoding.isoLatin1[200] = names.get("Egrave");
        Encoding.isoLatin1[201] = names.get("Eacute");
        Encoding.isoLatin1[202] = names.get("Ecircumflex");
        Encoding.isoLatin1[203] = names.get("Edieresis");
        Encoding.isoLatin1[204] = names.get("Igrave");
        Encoding.isoLatin1[205] = names.get("Iacute");
        Encoding.isoLatin1[206] = names.get("Icircumflex");
        Encoding.isoLatin1[207] = names.get("Idieresis");
        Encoding.isoLatin1[208] = names.get("Eth");
        Encoding.isoLatin1[209] = names.get("Ntilde");
        Encoding.isoLatin1[210] = names.get("Ograve");
        Encoding.isoLatin1[211] = names.get("Oacute");
        Encoding.isoLatin1[212] = names.get("Ocircumflex");
        Encoding.isoLatin1[213] = names.get("Otilde");
        Encoding.isoLatin1[214] = names.get("Odieresis");
        Encoding.isoLatin1[215] = names.get("multiply");
        Encoding.isoLatin1[216] = names.get("Oslash");
        Encoding.isoLatin1[217] = names.get("Ugrave");
        Encoding.isoLatin1[218] = names.get("Uacute");
        Encoding.isoLatin1[219] = names.get("Ucircumflex");
        Encoding.isoLatin1[220] = names.get("Udieresis");
        Encoding.isoLatin1[221] = names.get("Yacute");
        Encoding.isoLatin1[222] = names.get("Thorn");
        Encoding.isoLatin1[223] = names.get("germandbls");
        Encoding.isoLatin1[224] = names.get("agrave");
        Encoding.isoLatin1[225] = names.get("aacute");
        Encoding.isoLatin1[226] = names.get("acircumflex");
        Encoding.isoLatin1[227] = names.get("atilde");
        Encoding.isoLatin1[228] = names.get("adieresis");
        Encoding.isoLatin1[229] = names.get("aring");
        Encoding.isoLatin1[230] = names.get("ae");
        Encoding.isoLatin1[231] = names.get("ccedilla");
        Encoding.isoLatin1[232] = names.get("egrave");
        Encoding.isoLatin1[233] = names.get("eacute");
        Encoding.isoLatin1[234] = names.get("ecircumflex");
        Encoding.isoLatin1[235] = names.get("edieresis");
        Encoding.isoLatin1[236] = names.get("igrave");
        Encoding.isoLatin1[237] = names.get("iacute");
        Encoding.isoLatin1[238] = names.get("icircumflex");
        Encoding.isoLatin1[239] = names.get("idieresis");
        Encoding.isoLatin1[240] = names.get("eth");
        Encoding.isoLatin1[241] = names.get("ntilde");
        Encoding.isoLatin1[242] = names.get("ograve");
        Encoding.isoLatin1[243] = names.get("oacute");
        Encoding.isoLatin1[244] = names.get("ocircumflex");
        Encoding.isoLatin1[245] = names.get("otilde");
        Encoding.isoLatin1[246] = names.get("odieresis");
        Encoding.isoLatin1[247] = names.get("divide");
        Encoding.isoLatin1[248] = names.get("oslash");
        Encoding.isoLatin1[249] = names.get("ugrave");
        Encoding.isoLatin1[250] = names.get("uacute");
        Encoding.isoLatin1[251] = names.get("ucircumflex");
        Encoding.isoLatin1[252] = names.get("udieresis");
        Encoding.isoLatin1[253] = names.get("yacute");
        Encoding.isoLatin1[254] = names.get("thorn");
        Encoding.isoLatin1[255] = names.get("ydieresis");
    }

    private static void initSymbolEncoding() {
        Encoding.symbol[0] = names.get(".notdef");
        Encoding.symbol[1] = names.get(".notdef");
        Encoding.symbol[2] = names.get(".notdef");
        Encoding.symbol[3] = names.get(".notdef");
        Encoding.symbol[4] = names.get(".notdef");
        Encoding.symbol[5] = names.get(".notdef");
        Encoding.symbol[6] = names.get(".notdef");
        Encoding.symbol[7] = names.get(".notdef");
        Encoding.symbol[8] = names.get(".notdef");
        Encoding.symbol[9] = names.get(".notdef");
        Encoding.symbol[10] = names.get(".notdef");
        Encoding.symbol[11] = names.get(".notdef");
        Encoding.symbol[12] = names.get(".notdef");
        Encoding.symbol[13] = names.get(".notdef");
        Encoding.symbol[14] = names.get(".notdef");
        Encoding.symbol[15] = names.get(".notdef");
        Encoding.symbol[16] = names.get(".notdef");
        Encoding.symbol[17] = names.get(".notdef");
        Encoding.symbol[18] = names.get(".notdef");
        Encoding.symbol[19] = names.get(".notdef");
        Encoding.symbol[20] = names.get(".notdef");
        Encoding.symbol[21] = names.get(".notdef");
        Encoding.symbol[22] = names.get(".notdef");
        Encoding.symbol[23] = names.get(".notdef");
        Encoding.symbol[24] = names.get(".notdef");
        Encoding.symbol[25] = names.get(".notdef");
        Encoding.symbol[26] = names.get(".notdef");
        Encoding.symbol[27] = names.get(".notdef");
        Encoding.symbol[28] = names.get(".notdef");
        Encoding.symbol[29] = names.get(".notdef");
        Encoding.symbol[30] = names.get(".notdef");
        Encoding.symbol[31] = names.get(".notdef");
        Encoding.symbol[32] = names.get("space");
        Encoding.symbol[33] = names.get("exclam");
        Encoding.symbol[34] = names.get("universal");
        Encoding.symbol[35] = names.get("numbersign");
        Encoding.symbol[36] = names.get("existential");
        Encoding.symbol[37] = names.get("percent");
        Encoding.symbol[38] = names.get("ampersand");
        Encoding.symbol[39] = names.get("suchthat");
        Encoding.symbol[40] = names.get("parenleft");
        Encoding.symbol[41] = names.get("parenright");
        Encoding.symbol[42] = names.get("asterisk");
        Encoding.symbol[43] = names.get("plus");
        Encoding.symbol[44] = names.get("comma");
        Encoding.symbol[45] = names.get("minus");
        Encoding.symbol[46] = names.get("period");
        Encoding.symbol[47] = names.get("slash");
        Encoding.symbol[48] = names.get("zero");
        Encoding.symbol[49] = names.get("one");
        Encoding.symbol[50] = names.get("two");
        Encoding.symbol[51] = names.get("three");
        Encoding.symbol[52] = names.get("four");
        Encoding.symbol[53] = names.get("five");
        Encoding.symbol[54] = names.get("six");
        Encoding.symbol[55] = names.get("seven");
        Encoding.symbol[56] = names.get("eight");
        Encoding.symbol[57] = names.get("nine");
        Encoding.symbol[58] = names.get("colon");
        Encoding.symbol[59] = names.get("semicolon");
        Encoding.symbol[60] = names.get("less");
        Encoding.symbol[61] = names.get("equal");
        Encoding.symbol[62] = names.get("greater");
        Encoding.symbol[63] = names.get("question");
        Encoding.symbol[64] = names.get("congruent");
        Encoding.symbol[65] = names.get("Alpha");
        Encoding.symbol[66] = names.get("Beta");
        Encoding.symbol[67] = names.get("Chi");
        Encoding.symbol[68] = names.get("Delta");
        Encoding.symbol[69] = names.get("Epsilon");
        Encoding.symbol[70] = names.get("Phi");
        Encoding.symbol[71] = names.get("Gamma");
        Encoding.symbol[72] = names.get("Eta");
        Encoding.symbol[73] = names.get("Iota");
        Encoding.symbol[74] = names.get("theta1");
        Encoding.symbol[75] = names.get("Kappa");
        Encoding.symbol[76] = names.get("Lambda");
        Encoding.symbol[77] = names.get("Mu");
        Encoding.symbol[78] = names.get("Nu");
        Encoding.symbol[79] = names.get("Omicron");
        Encoding.symbol[80] = names.get("Pi");
        Encoding.symbol[81] = names.get("Theta");
        Encoding.symbol[82] = names.get("Rho");
        Encoding.symbol[83] = names.get("Sigma");
        Encoding.symbol[84] = names.get("Tau");
        Encoding.symbol[85] = names.get("Upsilon");
        Encoding.symbol[86] = names.get("sigma1");
        Encoding.symbol[87] = names.get("Omega");
        Encoding.symbol[88] = names.get("Xi");
        Encoding.symbol[89] = names.get("Psi");
        Encoding.symbol[90] = names.get("Zeta");
        Encoding.symbol[91] = names.get("bracketleft");
        Encoding.symbol[92] = names.get("therefore");
        Encoding.symbol[93] = names.get("bracketright");
        Encoding.symbol[94] = names.get("perpendicular");
        Encoding.symbol[95] = names.get("underscore");
        Encoding.symbol[96] = names.get("radicalex");
        Encoding.symbol[97] = names.get("alpha");
        Encoding.symbol[98] = names.get("beta");
        Encoding.symbol[99] = names.get("chi");
        Encoding.symbol[100] = names.get("delta");
        Encoding.symbol[101] = names.get("epsilon");
        Encoding.symbol[102] = names.get("phi");
        Encoding.symbol[103] = names.get("gamma");
        Encoding.symbol[104] = names.get("eta");
        Encoding.symbol[105] = names.get("iota");
        Encoding.symbol[106] = names.get("phi1");
        Encoding.symbol[107] = names.get("kappa");
        Encoding.symbol[108] = names.get("lambda");
        Encoding.symbol[109] = names.get("mu");
        Encoding.symbol[110] = names.get("nu");
        Encoding.symbol[111] = names.get("omicron");
        Encoding.symbol[112] = names.get("pi");
        Encoding.symbol[113] = names.get("theta");
        Encoding.symbol[114] = names.get("rho");
        Encoding.symbol[115] = names.get("sigma");
        Encoding.symbol[116] = names.get("tau");
        Encoding.symbol[117] = names.get("upsilon");
        Encoding.symbol[118] = names.get("omega1");
        Encoding.symbol[119] = names.get("omega");
        Encoding.symbol[120] = names.get("xi");
        Encoding.symbol[121] = names.get("psi");
        Encoding.symbol[122] = names.get("zeta");
        Encoding.symbol[123] = names.get("braceleft");
        Encoding.symbol[124] = names.get("bar");
        Encoding.symbol[125] = names.get("braceright");
        Encoding.symbol[126] = names.get("similar");
        Encoding.symbol[127] = names.get(".notdef");
        Encoding.symbol[128] = names.get(".notdef");
        Encoding.symbol[129] = names.get(".notdef");
        Encoding.symbol[130] = names.get(".notdef");
        Encoding.symbol[131] = names.get(".notdef");
        Encoding.symbol[132] = names.get(".notdef");
        Encoding.symbol[133] = names.get(".notdef");
        Encoding.symbol[134] = names.get(".notdef");
        Encoding.symbol[135] = names.get(".notdef");
        Encoding.symbol[136] = names.get(".notdef");
        Encoding.symbol[137] = names.get(".notdef");
        Encoding.symbol[138] = names.get(".notdef");
        Encoding.symbol[139] = names.get(".notdef");
        Encoding.symbol[140] = names.get(".notdef");
        Encoding.symbol[141] = names.get(".notdef");
        Encoding.symbol[142] = names.get(".notdef");
        Encoding.symbol[143] = names.get(".notdef");
        Encoding.symbol[144] = names.get(".notdef");
        Encoding.symbol[145] = names.get(".notdef");
        Encoding.symbol[146] = names.get(".notdef");
        Encoding.symbol[147] = names.get(".notdef");
        Encoding.symbol[148] = names.get(".notdef");
        Encoding.symbol[149] = names.get(".notdef");
        Encoding.symbol[150] = names.get(".notdef");
        Encoding.symbol[151] = names.get(".notdef");
        Encoding.symbol[152] = names.get(".notdef");
        Encoding.symbol[153] = names.get(".notdef");
        Encoding.symbol[154] = names.get(".notdef");
        Encoding.symbol[155] = names.get(".notdef");
        Encoding.symbol[156] = names.get(".notdef");
        Encoding.symbol[157] = names.get(".notdef");
        Encoding.symbol[158] = names.get(".notdef");
        Encoding.symbol[159] = names.get(".notdef");
        Encoding.symbol[160] = names.get("Euro");
        Encoding.symbol[161] = names.get("Upsilon1");
        Encoding.symbol[162] = names.get("minute");
        Encoding.symbol[163] = names.get("lessequal");
        Encoding.symbol[164] = names.get("fraction");
        Encoding.symbol[165] = names.get("infinity");
        Encoding.symbol[166] = names.get("florin");
        Encoding.symbol[167] = names.get("club");
        Encoding.symbol[168] = names.get("diamond");
        Encoding.symbol[169] = names.get("heart");
        Encoding.symbol[170] = names.get("spade");
        Encoding.symbol[171] = names.get("arrowboth");
        Encoding.symbol[172] = names.get("arrowleft");
        Encoding.symbol[173] = names.get("arrowup");
        Encoding.symbol[174] = names.get("arrowright");
        Encoding.symbol[175] = names.get("arrowdown");
        Encoding.symbol[176] = names.get("degree");
        Encoding.symbol[177] = names.get("plusminus");
        Encoding.symbol[178] = names.get("second");
        Encoding.symbol[179] = names.get("greaterequal");
        Encoding.symbol[180] = names.get("multiply");
        Encoding.symbol[181] = names.get("proportional");
        Encoding.symbol[182] = names.get("partialdiff");
        Encoding.symbol[183] = names.get("bullet");
        Encoding.symbol[184] = names.get("divide");
        Encoding.symbol[185] = names.get("notequal");
        Encoding.symbol[186] = names.get("equivalence");
        Encoding.symbol[187] = names.get("approxequal");
        Encoding.symbol[188] = names.get("ellipsis");
        Encoding.symbol[189] = names.get("arrowvertex");
        Encoding.symbol[190] = names.get("arrowhorizex");
        Encoding.symbol[191] = names.get("carriagereturn");
        Encoding.symbol[192] = names.get("aleph");
        Encoding.symbol[193] = names.get("Ifraktur");
        Encoding.symbol[194] = names.get("Rfraktur");
        Encoding.symbol[195] = names.get("weierstrass");
        Encoding.symbol[196] = names.get("circlemultiply");
        Encoding.symbol[197] = names.get("circleplus");
        Encoding.symbol[198] = names.get("emptyset");
        Encoding.symbol[199] = names.get("intersection");
        Encoding.symbol[200] = names.get("union");
        Encoding.symbol[201] = names.get("propersuperset");
        Encoding.symbol[202] = names.get("reflexsuperset");
        Encoding.symbol[203] = names.get("notsubset");
        Encoding.symbol[204] = names.get("propersubset");
        Encoding.symbol[205] = names.get("reflexsubset");
        Encoding.symbol[206] = names.get("element");
        Encoding.symbol[207] = names.get("notelement");
        Encoding.symbol[208] = names.get("angle");
        Encoding.symbol[209] = names.get("gradient");
        Encoding.symbol[210] = names.get("registerserif");
        Encoding.symbol[211] = names.get("copyrightserif");
        Encoding.symbol[212] = names.get("trademarkserif");
        Encoding.symbol[213] = names.get("product");
        Encoding.symbol[214] = names.get("radical");
        Encoding.symbol[215] = names.get("dotmath");
        Encoding.symbol[216] = names.get("logicalnot");
        Encoding.symbol[217] = names.get("logicaland");
        Encoding.symbol[218] = names.get("logicalor");
        Encoding.symbol[219] = names.get("arrowdblboth");
        Encoding.symbol[220] = names.get("arrowdblleft");
        Encoding.symbol[221] = names.get("arrowdblup");
        Encoding.symbol[222] = names.get("arrowdblright");
        Encoding.symbol[223] = names.get("arrowdbldown");
        Encoding.symbol[224] = names.get("lozenge");
        Encoding.symbol[225] = names.get("angleleft");
        Encoding.symbol[226] = names.get("registersans");
        Encoding.symbol[227] = names.get("copyrightsans");
        Encoding.symbol[228] = names.get("trademarksans");
        Encoding.symbol[229] = names.get("summation");
        Encoding.symbol[230] = names.get("parenlefttp");
        Encoding.symbol[231] = names.get("parenleftex");
        Encoding.symbol[232] = names.get("parenleftbt");
        Encoding.symbol[233] = names.get("bracketlefttp");
        Encoding.symbol[234] = names.get("bracketleftex");
        Encoding.symbol[235] = names.get("bracketleftbt");
        Encoding.symbol[236] = names.get("bracelefttp");
        Encoding.symbol[237] = names.get("braceleftmid");
        Encoding.symbol[238] = names.get("braceleftbt");
        Encoding.symbol[239] = names.get("braceex");
        Encoding.symbol[240] = names.get(".notdef");
        Encoding.symbol[241] = names.get("angleright");
        Encoding.symbol[242] = names.get("integral");
        Encoding.symbol[243] = names.get("integraltp");
        Encoding.symbol[244] = names.get("integralex");
        Encoding.symbol[245] = names.get("integralbt");
        Encoding.symbol[246] = names.get("parenrighttp");
        Encoding.symbol[247] = names.get("parenrightex");
        Encoding.symbol[248] = names.get("parenrightbt");
        Encoding.symbol[249] = names.get("bracketrighttp");
        Encoding.symbol[250] = names.get("bracketrightex");
        Encoding.symbol[251] = names.get("bracketrightbt");
        Encoding.symbol[252] = names.get("bracerighttp");
        Encoding.symbol[253] = names.get("bracerightmid");
        Encoding.symbol[254] = names.get("bracerightbt");
        Encoding.symbol[255] = names.get(".notdef");
    }

    static {
        standard = new PSObjectName[256];
        isoLatin1 = new PSObjectName[256];
        symbol = new PSObjectName[256];
    }
}

