% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pgTools2.R
\name{dropTABLE}
\alias{dropTABLE}
\title{Generate a postgreSQL DROP TABLE statement, optionally execute the statement if con is not NULL.}
\usage{
dropTABLE(
  name,
  if_exists = FALSE,
  cascade = FALSE,
  restrict = FALSE,
  con = NULL
)
}
\arguments{
\item{name}{A string, the "name" parameter for postgreSQL DROP TABLE.}

\item{if_exists}{TRUE/FALSE, if TRUE, adds "IF EXISTS" to postgreSQL DROP TABLE statement.}

\item{cascade}{TRUE/FALSE, if TRUE, adds "CASCADE" to postgreSQL DROP TABLE statement.}

\item{restrict}{TRUE/FALSE, if TRUE, adds "RESTRICT" to postgreSQL DROP TABLE statement.}

\item{con}{A database connection that can be passed to DBI::dbSendQuery/DBI::dbGetQuery.}
}
\value{
A string, postgreSQL DROP TABLE statement; or the results retrieved by DBI::dbSendQuery after executing the statement.
}
\description{
Generate a postgreSQL DROP TABLE statement, optionally execute the statement if con is not NULL.
}
\examples{
dropTABLE("sample")
}
