% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_private.R
\name{compute_clustermass}
\alias{compute_clustermass}
\title{Clustermass test correction}
\usage{
compute_clustermass(distribution, threshold, aggr_FUN, alternative = "greater")
}
\arguments{
\item{distribution}{A matrix of permuted statistical signal. The first row indicating the observed statistics.}

\item{threshold}{A scalar that respresents the threshold to create the clusters.}

\item{aggr_FUN}{A function to compute the clustermasses. See details for examples.}

\item{alternative}{A character string indicating the alternative hypothesis. Default is \code{"greater"}. Choose between \code{"greater"}, \code{"less"} or \code{"two.sided"}.}
}
\description{
Compute the clustermass test correction given a matrix a permuted statistical signals.
}
\details{
The \code{aggr_FUN} argument may take predefined function as the sum: \code{aggr_FUN = sum} and also user-defined function as the sum of squares: \code{aggr_FUN = function(x){sum(x^2)}}
}
