% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/downloadFile.R
\name{downloadFile_ValidateTypes}
\alias{downloadFile_ValidateTypes}
\title{Check passed file types against downloadFile module allowed file types list}
\usage{
downloadFile_ValidateTypes(types)
}
\arguments{
\item{types}{list of types to test}
}
\value{
the list input given in types
}
\description{
It is a downloadFile module helper to return periscope2 defined file types list and warns user if an invalid type is included
}
\examples{
  #inside console
  ## Check valid types
  result <- periscope2::downloadFile_AvailableTypes()
  identical(result, c("csv", "xlsx", "tsv", "txt", "png", "jpeg", "tiff", "bmp"))

  ## check invalid type
  testthat::expect_warning(downloadFile_ValidateTypes(types = "csv_invalid"),
                           "file download list contains an invalid type <csv_invalid>")


}
\seealso{
\link[periscope2]{downloadFileButton}

\link[periscope2]{downloadFile}

\link[periscope2]{logViewerOutput}

\link[periscope2]{downloadablePlot}

\link[periscope2]{downloadableTableUI}

\link[periscope2]{downloadableTable}
}
