% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_helpers.R
\name{set_app_parameters}
\alias{set_app_parameters}
\title{Set Application Parameters}
\usage{
set_app_parameters(
  title,
  app_info = NULL,
  log_level = "DEBUG",
  app_version = "1.0.0",
  loading_indicator = NULL,
  announcements_file = NULL
)
}
\arguments{
\item{title}{- Application title text}

\item{app_info}{- Application detailed information. It can be character string, HTML value or NULL
\itemize{
         \item{A \strong{character} string will be used to set a link target.
               This means the user will be able to click on the application title and be
               redirected in a new window to whatever value is given in the string.
               Any valid URL, File, or other script functionality that would normally be
               accepted in an <a href=...>  tag is allowed.}
         \item{An \strong{HTML} value will be used to as the HTML content for a modal pop-up
               window that will appear on-top of the application when the user clicks on the
               application title.}
         \item{Supplying \strong{NULL} will disable the title link functionality.}
}}

\item{log_level}{- Designating the log level to use for the user log as 'DEBUG','INFO', 'WARN' or 'ERROR' (default = 'DEBUG')}

\item{app_version}{- Character string designating the application version (default = '1.0.0')}

\item{loading_indicator}{- It uses waiter (see https://waiter.john-coene.com/#/).\cr
Pass a list like list(html = spin_1(), color = "#333e48") to \cr configure
waiterShowOnLoad (refer to the package help for all styles).}

\item{announcements_file}{- The path to announcements configuration file}
}
\value{
no return value, called for setting new application global properties
}
\description{
This function sets global parameters customizing the shiny application.
}
\section{Shiny Usage}{

Call this function from \code{program/global.R} to set the application
parameters.
}

\examples{
  library(shiny)
  library(waiter)
  library(periscope2)

  # Inside program/global.R
  set_app_parameters(title              = "periscope Example Application",
                     app_info           = HTML("Example info"),
                     log_level          = "DEBUG",
                     app_version        = "1.0.0",
                     loading_indicator  = list(html = tagList(spin_1(), "Loading ...")),
                     announcements_file = "./program/config/announce.yaml")

}
\seealso{
\link[waiter:waiter]{waiter:waiter_show()}

\link[periscope2:add_ui_footer]{periscope2:add_ui_footer()}

\link[periscope2:add_ui_left_sidebar]{periscope2:add_ui_left_sidebar()}

\link[periscope2:add_ui_header]{periscope2:add_ui_header()}

\link[periscope2:add_ui_body]{periscope2:add_ui_body()}

\link[periscope2:add_ui_right_sidebar]{periscope2:add_ui_right_sidebar()}

\link[periscope2:ui_tooltip]{periscope2:ui_tooltip()}

\link[periscope2:get_url_parameters]{periscope2:get_url_parameters()}
}
