% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/check_autocorrelation.R
\name{check_autocorrelation}
\alias{check_autocorrelation}
\alias{check_autocorrelation.default}
\title{Check model for independence of residuals.}
\usage{
check_autocorrelation(x, ...)

\method{check_autocorrelation}{default}(x, nsim = 1000, ...)
}
\arguments{
\item{x}{A model object.}

\item{...}{Currently not used.}

\item{nsim}{Number of simulations for the Durbin-Watson-Test.}
}
\value{
Invisibly returns the p-value of the test statistics. A p-value < 0.05
indicates autocorrelated residuals.
}
\description{
Check model for independence of residuals, i.e. for autocorrelation
of error terms.
}
\details{
Performs a Durbin-Watson-Test to check for autocorrelated residuals.
In case of autocorrelation, robust standard errors return more accurate
results for the estimates, or maybe a mixed model with error term for the
cluster groups should be used.
}
\examples{
m <- lm(mpg ~ wt + cyl + gear + disp, data = mtcars)
check_autocorrelation(m)
}
\seealso{
Other functions to check model assumptions and and assess model quality: 
\code{\link{check_collinearity}()},
\code{\link{check_convergence}()},
\code{\link{check_heteroscedasticity}()},
\code{\link{check_homogeneity}()},
\code{\link{check_model}()},
\code{\link{check_outliers}()},
\code{\link{check_overdispersion}()},
\code{\link{check_predictions}()},
\code{\link{check_singularity}()},
\code{\link{check_zeroinflation}()}
}
\concept{functions to check model assumptions and and assess model quality}
