% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/additional-options.R
\name{mstep_options}
\alias{mstep_options}
\title{Additional Options for the Penalized EN MM-estimator}
\usage{
mstep_options(cc = 3.44, maxit = 1000, eps = 1e-06, adjust_bdp = FALSE,
  verbosity = 0, en_correction = TRUE)
}
\arguments{
\item{cc}{tuning constant for the M-estimator.}

\item{maxit}{maximum number of iterations allowed.}

\item{eps}{numeric tolerance for convergence.}

\item{adjust_bdp}{should the breakdown point be adjusted based on the
effective degrees of freedom?}

\item{verbosity}{verbosity of the algorithm.}

\item{en_correction}{should the corrected EN estimator be used to choose
the optimal lambda with CV.
If \code{TRUE}, as by default, the estimator is "bias corrected".}
}
\value{
a checked options list.
}
\description{
Additional Options for the Penalized EN MM-estimator
}
\seealso{
Other specifying additional options: \code{\link{en_options_aug_lars}},
  \code{\link{initest_options}},
  \code{\link{pense_options}}
}
