% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wrappers.R
\name{penhdfeppml_cluster}
\alias{penhdfeppml_cluster}
\title{Plugin Lasso Estimation}
\usage{
penhdfeppml_cluster(
  data,
  dep = 1,
  indep = NULL,
  fixed = NULL,
  cluster = NULL,
  selectobs = NULL,
  ...
)
}
\arguments{
\item{data}{A data frame containing all relevant variables.}

\item{dep}{A string with the name of the independent variable or a column number.}

\item{indep}{A vector with the names or column numbers of the regressors. If left unspecified,
all remaining variables (excluding fixed effects) are included in the regressor matrix.}

\item{fixed}{A vector with the names or column numbers of factor variables identifying the fixed effects,
or a list with the desired interactions between variables in \code{data}.}

\item{cluster}{A string with the name of the clustering variable or a column number.
It's also possible to input a vector with several variables, in which case the interaction of
all of them is taken as the clustering variable. Note that this is NOT OPTIONAL in this case:
our plugin algorithm requires clusters to be specified.}

\item{selectobs}{Optional. A vector indicating which observations to use (either a logical vector
or a numeric vector with row numbers, as usual when subsetting in R).}

\item{...}{Further options. For a full list of options, see \link{penhdfeppml_cluster_int}.}
}
\value{
An object of class \code{elnet} with the elements described in \link[glmnet]{glmnet}, as
well as the following:
\itemize{
\item \code{mu}: a 1 x \code{length(y)} matrix with the final values of the conditional mean \eqn{\mu}.
\item \code{deviance}.
\item \code{bic}: Bayesian Information Criterion.
\item \code{phi}: coefficient-specific penalty weights.
\item \code{x_resid}: matrix of demeaned regressors.
\item \code{z_resid}: vector of demeaned (transformed) dependent variable.
}
}
\description{
Performs plugin lasso - PPML estimation with HDFE. This is an internal function, called by
\code{mlfitppml} and \code{penhdfeppml} when users select the \code{method = "plugin"}
option, but it's made available as a stand-alone option for advanced users who may prefer to avoid
some overhead imposed by the wrappers.
}
\details{
This function is a thin wrapper around \code{penppml_cluster_int}, providing a more convenient interface
for data frames. Whereas the internal function requires some preliminary handling of data sets (\code{y}
must be a vector, \code{x} must be a matrix and \code{fes} must be provided in a list), the wrapper
takes a full data frame in the \code{data} argument, and users can simply specify which variables
correspond to y, x and the fixed effects, using either variable names or column numbers.

The plugin method uses coefficient-specific penalty weights that account for heteroskedasticity. The
penalty parameters are calculated automatically by the function using statistical theory - for a
brief discussion of this, see Breinlich, Corradi, Rocha, Ruta, Santos Silva and Zylkin (2021), and
for a more in-depth analysis, check Belloni, Chernozhukov, Hansen, and Kozbur (2016), which introduced
the specific implementation used in this package. Heuristically, the penalty parameters are set at
a level high enough so that the absolute value of the score for each regressor must be statistically
large relative to its standard error in order for the regressors to be selected.
}
\section{References}{

Breinlich, H., Corradi, V., Rocha, N., Ruta, M., Santos Silva, J.M.C. and T. Zylkin (2021).
"Machine Learning in International Trade Research: Evaluating the Impact of Trade Agreements",
Policy Research Working Paper; No. 9629. World Bank, Washington, DC.

Correia, S., P. Guimaraes and T. Zylkin (2020). "Fast Poisson estimation with high dimensional
fixed effects", \emph{STATA Journal}, 20, 90-115.

Gaure, S (2013). "OLS with multiple high dimensional category variables",
\emph{Computational Statistics & Data Analysis}, 66, 8-18.

Friedman, J., T. Hastie, and R. Tibshirani (2010). "Regularization paths for generalized linear
models via coordinate descent", \emph{Journal of Statistical Software}, 33, 1-22.

Belloni, A., V. Chernozhukov, C. Hansen and D. Kozbur (2016). "Inference in high dimensional panel
models with an application to gun control", \emph{Journal of Business & Economic Statistics}, 34, 590-605.
}

\examples{
# To reduce run time, we keep only countries in the Americas:
americas <- countries$iso[countries$region == "Americas"]
test <- penhdfeppml_cluster(data = trade[, -(5:6)],
                              dep = "export",
                              fixed = list(c("exp", "time"),
                                           c("imp", "time"),
                                           c("exp", "imp")),
                              cluster = c("exp", "imp"),
                              selectobs = (trade$imp \%in\% americas) & (trade$exp \%in\% americas),
                              tol = 1e-5, hdfetol = 1e-1)

}
