// Generated by rstantools.  Do not edit by hand.

/*
    pema is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    pema is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with pema.  If not, see <http://www.gnu.org/licenses/>.
*/
#ifndef MODELS_HPP
#define MODELS_HPP
#define STAN__SERVICES__COMMAND_HPP
#ifndef USE_STANC3
#define USE_STANC3
#endif
#include <rstan/rstaninc.hpp>
// Code generated by %%NAME%% %%VERSION%%
#include <stan/model/model_header.hpp>
namespace model_hs_prior_namespace {
inline void validate_positive_index(const char* var_name, const char* expr,
                                    int val) {
  if (val < 1) {
    std::stringstream msg;
    msg << "Found dimension size less than one in simplex declaration"
        << "; variable=" << var_name << "; dimension size expression=" << expr
        << "; expression value=" << val;
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
inline void validate_unit_vector_index(const char* var_name, const char* expr,
                                       int val) {
  if (val <= 1) {
    std::stringstream msg;
    if (val == 1) {
      msg << "Found dimension size one in unit vector declaration."
          << " One-dimensional unit vector is discrete"
          << " but the target distribution must be continuous."
          << " variable=" << var_name << "; dimension size expression=" << expr;
    } else {
      msg << "Found dimension size less than one in unit vector declaration"
          << "; variable=" << var_name << "; dimension size expression=" << expr
          << "; expression value=" << val;
    }
    std::string msg_str(msg.str());
    throw std::invalid_argument(msg_str.c_str());
  }
}
using std::istream;
using std::string;
using std::stringstream;
using std::vector;
using std::pow;
using stan::io::dump;
using stan::math::lgamma;
using stan::model::model_base_crtp;
using stan::model::rvalue;
using stan::model::cons_list;
using stan::model::index_uni;
using stan::model::index_max;
using stan::model::index_min;
using stan::model::index_min_max;
using stan::model::index_multi;
using stan::model::index_omni;
using stan::model::nil_index_list;
using namespace stan::math;
using stan::math::pow; 
stan::math::profile_map profiles__;
static int current_statement__= 0;
static const std::vector<string> locations_array__ = {" (found before start of program)",
                                                      " (in 'string', line 28, column 2 to column 10)",
                                                      " (in 'string', line 29, column 2 to column 16)",
                                                      " (in 'string', line 30, column 2 to column 26)",
                                                      " (in 'string', line 31, column 2 to column 24)",
                                                      " (in 'string', line 34, column 2 to column 9)",
                                                      " (in 'string', line 35, column 2 to column 65)",
                                                      " (in 'string', line 39, column 2 to column 32)",
                                                      " (in 'string', line 40, column 2 to line 41, column 15)",
                                                      " (in 'string', line 42, column 2 to line 43, column 19)",
                                                      " (in 'string', line 44, column 2 to column 67)",
                                                      " (in 'string', line 20, column 2 to column 19)",
                                                      " (in 'string', line 21, column 2 to column 26)",
                                                      " (in 'string', line 22, column 2 to column 24)",
                                                      " (in 'string', line 23, column 2 to column 29)",
                                                      " (in 'string', line 24, column 2 to column 27)",
                                                      " (in 'string', line 14, column 4 to column 34)",
                                                      " (in 'string', line 15, column 4 to column 69)",
                                                      " (in 'string', line 16, column 4 to column 35)",
                                                      " (in 'string', line 13, column 57 to line 17, column 3)"};
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<T0__, T1__, T2__,
T3__>
horseshoe(const T0__& z, const T1__& lambda, const T2__& tau, const T3__& c2,
          std::ostream* pstream__) {
  using local_scalar_t__ = stan::promote_args_t<T0__, T1__, T2__, T3__>;
  const static bool propto__ = true;
  (void) propto__;
  local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
  (void) DUMMY_VAR__;  // suppress unused var warning
  
  try {
    local_scalar_t__ lambda2;
    lambda2 = DUMMY_VAR__;
    
    current_statement__ = 16;
    lambda2 = square(lambda);
    local_scalar_t__ lambda_tilde;
    lambda_tilde = DUMMY_VAR__;
    
    current_statement__ = 17;
    lambda_tilde = stan::math::sqrt(
                     ((c2 * lambda2) / (c2 + (pow(tau, 2) * lambda2))));
    current_statement__ = 18;
    return ((z * lambda_tilde) * tau);
  } catch (const std::exception& e) {
    stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
  }
  
}
struct horseshoe_functor__ {
template <typename T0__, typename T1__, typename T2__, typename T3__>
stan::promote_args_t<T0__, T1__, T2__,
T3__>
operator()(const T0__& z, const T1__& lambda, const T2__& tau,
           const T3__& c2, std::ostream* pstream__)  const 
{
return horseshoe(z, lambda, tau, c2, pstream__);
}
};
#include <stan_meta_header.hpp>
class model_hs_prior final : public model_base_crtp<model_hs_prior> {
private:
  double df;
  double df_global;
  double df_slab;
  double scale_global;
  double scale_slab;
 
public:
  ~model_hs_prior() { }
  
  inline std::string model_name() const final { return "model_hs_prior"; }
  inline std::vector<std::string> model_compile_info() const noexcept {
    return std::vector<std::string>{"stanc_version = %%NAME%%3 %%VERSION%%", "stancflags = "};
  }
  
  
  model_hs_prior(stan::io::var_context& context__,
                 unsigned int random_seed__ = 0,
                 std::ostream* pstream__ = nullptr) : model_base_crtp(0) {
    using local_scalar_t__ = double ;
    boost::ecuyer1988 base_rng__ = 
        stan::services::util::create_rng(random_seed__, 0);
    (void) base_rng__;  // suppress unused var warning
    static const char* function__ = "model_hs_prior_namespace::model_hs_prior";
    (void) function__;  // suppress unused var warning
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      current_statement__ = 11;
      context__.validate_dims("data initialization","df","double",
          context__.to_vec());
      df = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 11;
      df = context__.vals_r("df")[(1 - 1)];
      current_statement__ = 11;
      current_statement__ = 11;
      check_greater_or_equal(function__, "df", df, 0);
      current_statement__ = 12;
      context__.validate_dims("data initialization","df_global","double",
          context__.to_vec());
      df_global = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 12;
      df_global = context__.vals_r("df_global")[(1 - 1)];
      current_statement__ = 12;
      current_statement__ = 12;
      check_greater_or_equal(function__, "df_global", df_global, 0);
      current_statement__ = 13;
      context__.validate_dims("data initialization","df_slab","double",
          context__.to_vec());
      df_slab = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 13;
      df_slab = context__.vals_r("df_slab")[(1 - 1)];
      current_statement__ = 13;
      current_statement__ = 13;
      check_greater_or_equal(function__, "df_slab", df_slab, 0);
      current_statement__ = 14;
      context__.validate_dims("data initialization","scale_global","double",
          context__.to_vec());
      scale_global = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 14;
      scale_global = context__.vals_r("scale_global")[(1 - 1)];
      current_statement__ = 14;
      current_statement__ = 14;
      check_greater_or_equal(function__, "scale_global", scale_global, 0);
      current_statement__ = 15;
      context__.validate_dims("data initialization","scale_slab","double",
          context__.to_vec());
      scale_slab = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 15;
      scale_slab = context__.vals_r("scale_slab")[(1 - 1)];
      current_statement__ = 15;
      current_statement__ = 15;
      check_greater_or_equal(function__, "scale_slab", scale_slab, 0);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    num_params_r__ = 0U;
    
    try {
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
      num_params_r__ += 1;
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
  }
  template <bool propto__, bool jacobian__, typename VecR, typename VecI, stan::require_vector_like_t<VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline stan::scalar_type_t<VecR> log_prob_impl(VecR& params_r__,
                                                 VecI& params_i__,
                                                 std::ostream* pstream__ = nullptr) const {
    using T__ = stan::scalar_type_t<VecR>;
    using local_scalar_t__ = T__;
    T__ lp__(0.0);
    stan::math::accumulator<T__> lp_accum__;
    static const char* function__ = "model_hs_prior_namespace::log_prob";
(void) function__;  // suppress unused var warning
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      local_scalar_t__ zb;
      zb = DUMMY_VAR__;
      
      current_statement__ = 1;
      zb = in__.scalar();
      local_scalar_t__ hs_local;
      hs_local = DUMMY_VAR__;
      
      current_statement__ = 2;
      hs_local = in__.scalar();
      local_scalar_t__ hs_global;
      hs_global = DUMMY_VAR__;
      
      current_statement__ = 3;
      hs_global = in__.scalar();
      current_statement__ = 3;
      if (jacobian__) {
        current_statement__ = 3;
        hs_global = stan::math::lb_constrain(hs_global, 0, lp__);
      } else {
        current_statement__ = 3;
        hs_global = stan::math::lb_constrain(hs_global, 0);
      }
      local_scalar_t__ hs_slab;
      hs_slab = DUMMY_VAR__;
      
      current_statement__ = 4;
      hs_slab = in__.scalar();
      current_statement__ = 4;
      if (jacobian__) {
        current_statement__ = 4;
        hs_slab = stan::math::lb_constrain(hs_slab, 0, lp__);
      } else {
        current_statement__ = 4;
        hs_slab = stan::math::lb_constrain(hs_slab, 0);
      }
      local_scalar_t__ b;
      b = DUMMY_VAR__;
      
      current_statement__ = 6;
      b = horseshoe(zb, hs_local, hs_global,
            (pow(scale_slab, 2) * hs_slab), pstream__);
      {
        current_statement__ = 7;
        lp_accum__.add(std_normal_lpdf<false>(zb));
        current_statement__ = 8;
        lp_accum__.add(
          (student_t_lpdf<false>(hs_local, df, 0, 1) - stan::math::log(0.5)));
        current_statement__ = 9;
        lp_accum__.add(
          (student_t_lpdf<false>(hs_global, df_global, 0, scale_global) -
            (1 * stan::math::log(0.5))));
        current_statement__ = 10;
        lp_accum__.add(
          inv_gamma_lpdf<false>(hs_slab, (0.5 * df_slab), (0.5 * df_slab)));
      }
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    lp_accum__.add(lp__);
    return lp_accum__.sum();
    } // log_prob_impl() 
    
  template <typename RNG, typename VecR, typename VecI, typename VecVar, stan::require_vector_like_vt<std::is_floating_point, VecR>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr, stan::require_std_vector_vt<std::is_floating_point, VecVar>* = nullptr>
  inline void write_array_impl(RNG& base_rng__, VecR& params_r__,
                               VecI& params_i__, VecVar& vars__,
                               const bool emit_transformed_parameters__ = true,
                               const bool emit_generated_quantities__ = true,
                               std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.resize(0);
    stan::io::reader<local_scalar_t__> in__(params_r__, params_i__);
    static const char* function__ = "model_hs_prior_namespace::write_array";
(void) function__;  // suppress unused var warning
    (void) function__;  // suppress unused var warning
    double lp__ = 0.0;
    (void) lp__;  // dummy to suppress unused var warning
    stan::math::accumulator<double> lp_accum__;
    local_scalar_t__ DUMMY_VAR__(std::numeric_limits<double>::quiet_NaN());
    (void) DUMMY_VAR__;  // suppress unused var warning
    
    try {
      double zb;
      zb = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      zb = in__.scalar();
      double hs_local;
      hs_local = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      hs_local = in__.scalar();
      double hs_global;
      hs_global = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      hs_global = in__.scalar();
      current_statement__ = 3;
      hs_global = stan::math::lb_constrain(hs_global, 0);
      double hs_slab;
      hs_slab = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      hs_slab = in__.scalar();
      current_statement__ = 4;
      hs_slab = stan::math::lb_constrain(hs_slab, 0);
      double b;
      b = std::numeric_limits<double>::quiet_NaN();
      
      vars__.emplace_back(zb);
      vars__.emplace_back(hs_local);
      vars__.emplace_back(hs_global);
      vars__.emplace_back(hs_slab);
      if (logical_negation((primitive_value(emit_transformed_parameters__) ||
            primitive_value(emit_generated_quantities__)))) {
        return ;
      } 
      current_statement__ = 6;
      b = horseshoe(zb, hs_local, hs_global,
            (pow(scale_slab, 2) * hs_slab), pstream__);
      if (emit_transformed_parameters__) {
        vars__.emplace_back(b);
      } 
      if (logical_negation(emit_generated_quantities__)) {
        return ;
      } 
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // write_array_impl() 
    
  template <typename VecVar, typename VecI, stan::require_std_vector_t<VecVar>* = nullptr, stan::require_vector_like_vt<std::is_integral, VecI>* = nullptr>
  inline void transform_inits_impl(const stan::io::var_context& context__,
                                   VecI& params_i__, VecVar& vars__,
                                   std::ostream* pstream__ = nullptr) const {
    using local_scalar_t__ = double;
    vars__.clear();
    vars__.reserve(num_params_r__);
    
    try {
      int pos__;
      pos__ = std::numeric_limits<int>::min();
      
      pos__ = 1;
      double zb;
      zb = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 1;
      zb = context__.vals_r("zb")[(1 - 1)];
      double hs_local;
      hs_local = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 2;
      hs_local = context__.vals_r("hs_local")[(1 - 1)];
      double hs_global;
      hs_global = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      hs_global = context__.vals_r("hs_global")[(1 - 1)];
      double hs_global_free__;
      hs_global_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 3;
      hs_global_free__ = stan::math::lb_free(hs_global, 0);
      double hs_slab;
      hs_slab = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      hs_slab = context__.vals_r("hs_slab")[(1 - 1)];
      double hs_slab_free__;
      hs_slab_free__ = std::numeric_limits<double>::quiet_NaN();
      
      current_statement__ = 4;
      hs_slab_free__ = stan::math::lb_free(hs_slab, 0);
      vars__.emplace_back(zb);
      vars__.emplace_back(hs_local);
      vars__.emplace_back(hs_global_free__);
      vars__.emplace_back(hs_slab_free__);
    } catch (const std::exception& e) {
      stan::lang::rethrow_located(e, locations_array__[current_statement__]);
      // Next line prevents compiler griping about no return
      throw std::runtime_error("*** IF YOU SEE THIS, PLEASE REPORT A BUG ***"); 
    }
    } // transform_inits_impl() 
    
  inline void get_param_names(std::vector<std::string>& names__) const {
    
    names__.clear();
    names__.emplace_back("zb");
    names__.emplace_back("hs_local");
    names__.emplace_back("hs_global");
    names__.emplace_back("hs_slab");
    names__.emplace_back("b");
    } // get_param_names() 
    
  inline void get_dims(std::vector<std::vector<size_t>>& dimss__) const {
    dimss__.clear();
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    dimss__.emplace_back(std::vector<size_t>{});
    
    } // get_dims() 
    
  inline void constrained_param_names(
                                      std::vector<std::string>& param_names__,
                                      bool emit_transformed_parameters__ = true,
                                      bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "zb");
    param_names__.emplace_back(std::string() + "hs_local");
    param_names__.emplace_back(std::string() + "hs_global");
    param_names__.emplace_back(std::string() + "hs_slab");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "b");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // constrained_param_names() 
    
  inline void unconstrained_param_names(
                                        std::vector<std::string>& param_names__,
                                        bool emit_transformed_parameters__ = true,
                                        bool emit_generated_quantities__ = true) const
    final {
    
    param_names__.emplace_back(std::string() + "zb");
    param_names__.emplace_back(std::string() + "hs_local");
    param_names__.emplace_back(std::string() + "hs_global");
    param_names__.emplace_back(std::string() + "hs_slab");
    if (emit_transformed_parameters__) {
      param_names__.emplace_back(std::string() + "b");
    }
    
    if (emit_generated_quantities__) {
      
    }
    
    } // unconstrained_param_names() 
    
  inline std::string get_constrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"zb\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_local\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_global\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_slab\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_constrained_sizedtypes() 
    
  inline std::string get_unconstrained_sizedtypes() const {
    stringstream s__;
    s__ << "[{\"name\":\"zb\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_local\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_global\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"hs_slab\",\"type\":{\"name\":\"real\"},\"block\":\"parameters\"},{\"name\":\"b\",\"type\":{\"name\":\"real\"},\"block\":\"transformed_parameters\"}]";
    return s__.str();
    } // get_unconstrained_sizedtypes() 
    
  
    // Begin method overload boilerplate
    template <typename RNG>
    inline void write_array(RNG& base_rng,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& params_r,
                            Eigen::Matrix<double,Eigen::Dynamic,1>& vars,
                            const bool emit_transformed_parameters = true,
                            const bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      std::vector<double> vars_vec(vars.size());
      std::vector<int> params_i;
      write_array_impl(base_rng, params_r, params_i, vars_vec,
          emit_transformed_parameters, emit_generated_quantities, pstream);
      vars.resize(vars_vec.size());
      for (int i = 0; i < vars.size(); ++i) {
        vars.coeffRef(i) = vars_vec[i];
      }
    }
    template <typename RNG>
    inline void write_array(RNG& base_rng, std::vector<double>& params_r,
                            std::vector<int>& params_i,
                            std::vector<double>& vars,
                            bool emit_transformed_parameters = true,
                            bool emit_generated_quantities = true,
                            std::ostream* pstream = nullptr) const {
      write_array_impl(base_rng, params_r, params_i, vars, emit_transformed_parameters, emit_generated_quantities, pstream);
    }
    template <bool propto__, bool jacobian__, typename T_>
    inline T_ log_prob(Eigen::Matrix<T_,Eigen::Dynamic,1>& params_r,
                       std::ostream* pstream = nullptr) const {
      Eigen::Matrix<int, -1, 1> params_i;
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
    template <bool propto__, bool jacobian__, typename T__>
    inline T__ log_prob(std::vector<T__>& params_r,
                        std::vector<int>& params_i,
                        std::ostream* pstream = nullptr) const {
      return log_prob_impl<propto__, jacobian__>(params_r, params_i, pstream);
    }
  
    inline void transform_inits(const stan::io::var_context& context,
                         Eigen::Matrix<double, Eigen::Dynamic, 1>& params_r,
                         std::ostream* pstream = nullptr) const final {
      std::vector<double> params_r_vec(params_r.size());
      std::vector<int> params_i;
      transform_inits_impl(context, params_i, params_r_vec, pstream);
      params_r.resize(params_r_vec.size());
      for (int i = 0; i < params_r.size(); ++i) {
        params_r.coeffRef(i) = params_r_vec[i];
      }
    }
    inline void transform_inits(const stan::io::var_context& context,
                                std::vector<int>& params_i,
                                std::vector<double>& vars,
                                std::ostream* pstream = nullptr) const final {
      transform_inits_impl(context, params_i, vars, pstream);
    }        
};
}
using stan_model = model_hs_prior_namespace::model_hs_prior;
#ifndef USING_R
// Boilerplate
stan::model::model_base& new_model(
        stan::io::var_context& data_context,
        unsigned int seed,
        std::ostream* msg_stream) {
  stan_model* m = new stan_model(data_context, seed, msg_stream);
  return *m;
}
stan::math::profile_map& get_stan_profile_data() {
  return model_hs_prior_namespace::profiles__;
}
#endif
#endif
