% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_entropy.R
\name{summ_entropy}
\alias{summ_entropy}
\alias{summ_entropy2}
\title{Summarize distribution with entropy}
\usage{
summ_entropy(f)

summ_entropy2(f, g, method = "relative", clip = exp(-20))
}
\arguments{
\item{f}{A pdqr-function representing distribution.}

\item{g}{A pdqr-function. Should be the same type as \code{f}.}

\item{method}{Entropy method for pair of distributions. One of "relative"
(Kullback–Leibler divergence) or "cross" (for cross-entropy).}

\item{clip}{Value to be used instead of 0 during \code{log()} computation.
\code{-log(clip)} represents the maximum value of output entropy.}
}
\value{
A single number representing entropy. If \code{clip} is strictly positive,
then it will be finite.
}
\description{
\code{summ_entropy()} computes entropy of single distribution while
\code{summ_entropy2()} - for a pair of distributions. For "discrete"
pdqr-functions a classic formula \code{-sum(p * log(p))} (in nats) is used. In
"continuous" case a differential entropy is computed.
}
\details{
\strong{Note} that due to \link[=pdqr_approx_error]{pdqr approximation error}
there can be a rather big error in entropy estimation in case original
density goes to infinity.
}
\examples{
d_norm <- as_d(dnorm)
d_norm_2 <- as_d(dnorm, mean = 2, sd = 0.5)

summ_entropy(d_norm)
summ_entropy2(d_norm, d_norm_2)
summ_entropy2(d_norm, d_norm_2, method = "cross")

# Increasing `clip` leads to decreasing maximum output value
d_1 <- new_d(1:10, "discrete")
d_2 <- new_d(20:21, "discrete")

  # Formally, output isn't clearly defined because functions don't have the
  # same support. Direct use of entropy formulas gives infinity output, but
  # here maximum value is `-log(clip)`.
summ_entropy2(d_1, d_2, method = "cross")
summ_entropy2(d_1, d_2, method = "cross", clip = exp(-10))
summ_entropy2(d_1, d_2, method = "cross", clip = 0)

}
\seealso{
Other summary functions: \code{\link{summ_center}},
  \code{\link{summ_classmetric}},
  \code{\link{summ_distance}}, \code{\link{summ_hdr}},
  \code{\link{summ_interval}}, \code{\link{summ_moment}},
  \code{\link{summ_order}}, \code{\link{summ_prob_true}},
  \code{\link{summ_pval}}, \code{\link{summ_quantile}},
  \code{\link{summ_roc}}, \code{\link{summ_separation}},
  \code{\link{summ_spread}}
}
\concept{summary functions}
