% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mds.R
\name{mds}
\alias{mds}
\title{Multidimensional scaling}
\usage{
mds(rfModels, dimensions = 2)
}
\arguments{
\item{rfModels}{list containing random forest models as returned by \code{rf()}}

\item{dimensions}{number of dimensions to scale to}
}
\description{
perform multidimensional scaling of random forest proximities
}
\examples{
library(dplyr)

## Retrieve file paths for example data
files <- list.files(system.file('phenotypeDataCollectionSheets',
  package = 'pdi'),full.names = TRUE)

## Prepare data
d <- map(files,readPhenotypeSheet) \%>\%
  map(preparePhenotypeData) \%>\%
  bind_rows() \%>\%
  siteAdjustment() \%>\%
   mutate(`Live crown ratio (\%)` = liveCrownRatio(`Total height (m)`,
     `Lower crown height (m)`),
     `Crown condition (\%)` = crownCondition(`Missing crown (\%)`,
                               `Crown transparency (\%)`),
     `Crown volume (m^3)` = crownVolume(`Crown radius (m)`,
                               `Total height (m)`,
                               `Lower crown height (m)`,
                               `Crown condition (\%)`),
     `Bleed prevalence (\%)` = bleedPrevalence(`Active bleed length (mm)`,
                               `Active bleeds`,
                               `Black staining length (mm)`,
                               `Black staining`,
                               `Diameter at breast height (m)`),
     `Agrilus exit hole density (m^-2)` = agrilusExitHoleDensity(`Agrilus exit holes`,
                               `Diameter at breast height (m)`)
)

t <- makeAnalysisTable(d)

## Generate random forest models
m <- rf(t,cls = NULL,nreps = 10)

mds_data <- mds(m,2)
}
