% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Mid}
\alias{Mid}
\title{Geodesic midpoint between HPD-matrices}
\usage{
Mid(A, B)
}
\arguments{
\item{A, B}{Hermitian positive definite matrices (of equal dimension).}
}
\description{
\code{Mid} calculates the geodesic midpoint between two Hermitian PD matrices as in
(Bhatia, 2009, Chapter 6).
}
\examples{
 a <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 A <- t(Conj(a)) \%*\% a
 b <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 B <- t(Conj(b)) \%*\% b
 Mid(A, B)
}
\references{
Bhatia, R. (2009). \emph{Positive Definite Matrices}. New Jersey: Princeton University Press.
}
\seealso{
\code{\link{pdMean}}
}
