% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dist.R
\name{pdDist}
\alias{pdDist}
\title{Compute distance between two HPD matrices}
\usage{
pdDist(A, B, method = "Riemannian")
}
\arguments{
\item{A, B}{Hermitian positive definite matrices (of equal dimension).}

\item{method}{the distance measure, one of \code{'Riemannian'},
\code{'logEuclidean'}, \code{'Cholesky'}, \code{'Euclidean'} or \code{'Procrustes'}. Defaults to \code{'Riemannian'}.}
}
\description{
\code{pdDist} calculates a distance between two Hermitian PD matrices.
}
\details{
Available distance measures between two Hermitian PD matrices are (i) Riemannian distance (default) as in
(Bhatia, 2009, Chapter 6), (ii) log-Euclidean distance, the Euclidean distance between matrix logarithms,
(iii) Cholesky distance, the Euclidean distance between Cholesky decompositions, (iv) Euclidean distance,
and (v) Procrustes distance as in (Dryden et al., 2009). In particular, \code{pdDist} generalizes the function
\code{\link[shapes]{distcov}} to compute the distance between two symmetric positive definite matrices to the
distance between two Hermitian positive definite matrices.
}
\examples{
 a <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 A <- t(Conj(a)) \%*\% a
 b <- matrix(complex(real = rnorm(9), imaginary = rnorm(9)), nrow = 3)
 B <- t(Conj(b)) \%*\% b
 pdDist(A, B) ## Riemannian distance

}
\references{
Bhatia, R. (2009). \emph{Positive Definite Matrices}. New Jersey: Princeton University Press.

Dryden, I.L., Koloydenko, A., Zhou, D. (2009). Non-Euclidean statistics for covariance matrices,
with applications to diffusion tensor imaging. \emph{Annals of Applied Statistics}, 3(3), 1102-1123.
}
\seealso{
\code{\link[shapes]{distcov}}
}
