% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Rtaxonkit.R
\name{taxonkit_list}
\alias{taxonkit_list}
\title{Taxonkit list}
\usage{
taxonkit_list(
  ids,
  indent = "  ",
  json = FALSE,
  show_name = FALSE,
  show_rank = FALSE,
  data_dir = NULL
)
}
\arguments{
\item{ids}{A character vector of TaxIDs to retrieve information for.}

\item{indent}{The indentation string to use for pretty-printing the output. Default is "  ".}

\item{json}{Logical value indicating whether to output the result in JSON format. Default is FALSE.}

\item{show_name}{Logical value indicating whether to show the scientific names of taxa. Default is FALSE.}

\item{show_rank}{Logical value indicating whether to show the ranks of taxa. Default is FALSE.}

\item{data_dir}{directory containing nodes.dmp and names.dmp (default "/Users/asa/.taxonkit")}
}
\value{
The output of the Taxonkit list operation.
}
\description{
This function uses Taxonkit to perform the "list" operation, which retrieves
information about taxa based on their TaxIDs.
}
\examples{
\dontrun{
taxonkit_list(ids = c(9605), indent = "-", show_name = TRUE, show_rank = TRUE)
}
}
