% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simExtraction.r
\name{simExtraction}
\alias{simExtraction}
\title{DNA Extraction Simulator}
\usage{
simExtraction(data = NULL, vol.ex = 100, sd.vol = 0, prob.ex = 0.3,
  sd.prob = 0, cell.dna = 0.006, debug = FALSE)
}
\arguments{
\item{data}{data.frame with simulated data. Preferably output from
\code{\link{simSample}}. Required columns are 'Marker', 'Allele', 'Sim', and 'DNA'.}

\item{vol.ex}{numeric for the final extraction volume (volume after extraction).}

\item{sd.vol}{numeric for the standard deviation of \code{vol.ex}.}

\item{prob.ex}{numeric for probability that an allele survives the extraction
(extraction efficiency).}

\item{sd.prob}{numeric for the standard deviation of \code{prob.ex}.}

\item{cell.dna}{numeric to indicate the DNA content of a diploid cell in nanograms (ng).}

\item{debug}{logical TRUE to indicate debug mode.}
}
\value{
data.frame with simulation results in columns 'Ex.Vol', 'Ex.Prob',
Ex.DNA', 'Ex.Conc', and updated 'DNA' and 'Volume' columns (added if needed).
}
\description{
Simulates the DNA extraction process.
}
\details{
Simulates the DNA extraction process by a series of normal
distributions. The number of molecules is taken from the required column
'DNA' which is \code{floor}ed to avoid NAs in the \code{rbinom} function.
}
\examples{
# Create a data frame with a DNA profile.
markers = rep(c("D3S1358","TH01","FGA"), each=2)
alleles = c(15,18,6,10,25,25)
df <- data.frame(Marker=markers, Allele=alleles)

# Simulate profile.
res <- simProfile(data=df, sim=3, name="Test")

# Simulate diploid sample.
res <- simSample(data=res, cells=100, sd.cells=20)

# [OPTIONAL] Simulate degradation.
res <- simDegradation(data=res, kit="ESX17", deg=0.003, quant.target=80)

# Simulate extraction.
res <- simExtraction(data=res, vol.ex=200, sd.vol=10, prob.ex=0.3, sd.prob=0.1)
}
\seealso{
\code{\link{simSample}}
}
